@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property offer Offer used by this capacity reservation group.
 * @property reservedCapacity [Required] Specifies the amount of capacity to reserve.
 */
public data class CapacityReservationGroupResponse(
    public val offer: ServerlessOfferResponse? = null,
    public val reservedCapacity: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CapacityReservationGroupResponse):
            CapacityReservationGroupResponse = CapacityReservationGroupResponse(
            offer = javaType.offer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ServerlessOfferResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            reservedCapacity = javaType.reservedCapacity(),
        )
    }
}
