@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Command Job limit class.
 * @property jobLimitsType
 * Expected value is 'Command'.
 * @property timeout The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
 */
public data class CommandJobLimitsResponse(
    public val jobLimitsType: String,
    public val timeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CommandJobLimitsResponse):
            CommandJobLimitsResponse = CommandJobLimitsResponse(
            jobLimitsType = javaType.jobLimitsType(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
