@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Compute Instance properties
 * @property applicationSharingPolicy Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
 * @property applications Describes available applications and their endpoints on this ComputeInstance.
 * @property computeInstanceAuthorizationType The Compute Instance Authorization type. Available values are personal (default).
 * @property connectivityEndpoints Describes all connectivity endpoints available for this ComputeInstance.
 * @property containers Describes informations of containers on this ComputeInstance.
 * @property createdBy Describes information on user who created this ComputeInstance.
 * @property customServices List of Custom Services added to the compute.
 * @property dataDisks Describes informations of dataDisks on this ComputeInstance.
 * @property dataMounts Describes informations of dataMounts on this ComputeInstance.
 * @property enableNodePublicIp Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
 * @property errors Collection of errors encountered on this ComputeInstance.
 * @property lastOperation The last operation on ComputeInstance.
 * @property osImageMetadata Returns metadata about the operating system image for this compute instance.
 * @property personalComputeInstanceSettings Settings for a personal compute instance.
 * @property schedules The list of schedules to be applied on the computes.
 * @property setupScripts Details of customized scripts to execute for setting up the cluster.
 * @property sshSettings Specifies policy and settings for SSH access.
 * @property state The current state of this ComputeInstance.
 * @property subnet Virtual network subnet resource ID the compute nodes belong to.
 * @property versions ComputeInstance version.
 * @property vmSize Virtual Machine Size
 */
public data class ComputeInstancePropertiesResponse(
    public val applicationSharingPolicy: String? = null,
    public val applications: List<ComputeInstanceApplicationResponse>,
    public val computeInstanceAuthorizationType: String? = null,
    public val connectivityEndpoints: ComputeInstanceConnectivityEndpointsResponse,
    public val containers: List<ComputeInstanceContainerResponse>,
    public val createdBy: ComputeInstanceCreatedByResponse,
    public val customServices: List<CustomServiceResponse>? = null,
    public val dataDisks: List<ComputeInstanceDataDiskResponse>,
    public val dataMounts: List<ComputeInstanceDataMountResponse>,
    public val enableNodePublicIp: Boolean? = null,
    public val errors: List<ErrorResponseResponse>,
    public val lastOperation: ComputeInstanceLastOperationResponse,
    public val osImageMetadata: ImageMetadataResponse,
    public val personalComputeInstanceSettings: PersonalComputeInstanceSettingsResponse? = null,
    public val schedules: ComputeSchedulesResponse? = null,
    public val setupScripts: SetupScriptsResponse? = null,
    public val sshSettings: ComputeInstanceSshSettingsResponse? = null,
    public val state: String,
    public val subnet: ResourceIdResponse? = null,
    public val versions: ComputeInstanceVersionResponse,
    public val vmSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ComputeInstancePropertiesResponse):
            ComputeInstancePropertiesResponse = ComputeInstancePropertiesResponse(
            applicationSharingPolicy = javaType.applicationSharingPolicy().map({ args0 -> args0 }).orElse(null),
            applications = javaType.applications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceApplicationResponse.Companion.toKotlin(args0)
                })
            }),
            computeInstanceAuthorizationType = javaType.computeInstanceAuthorizationType().map({ args0 ->
                args0
            }).orElse(null),
            connectivityEndpoints = javaType.connectivityEndpoints().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceConnectivityEndpointsResponse.Companion.toKotlin(args0)
            }),
            containers = javaType.containers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceContainerResponse.Companion.toKotlin(args0)
                })
            }),
            createdBy = javaType.createdBy().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceCreatedByResponse.Companion.toKotlin(args0)
            }),
            customServices = javaType.customServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CustomServiceResponse.Companion.toKotlin(args0)
                })
            }),
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceDataDiskResponse.Companion.toKotlin(args0)
                })
            }),
            dataMounts = javaType.dataMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceDataMountResponse.Companion.toKotlin(args0)
                })
            }),
            enableNodePublicIp = javaType.enableNodePublicIp().map({ args0 -> args0 }).orElse(null),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }),
            lastOperation = javaType.lastOperation().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceLastOperationResponse.Companion.toKotlin(args0)
            }),
            osImageMetadata = javaType.osImageMetadata().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ImageMetadataResponse.Companion.toKotlin(args0)
            }),
            personalComputeInstanceSettings = javaType.personalComputeInstanceSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.PersonalComputeInstanceSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schedules = javaType.schedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeSchedulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            setupScripts = javaType.setupScripts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SetupScriptsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sshSettings = javaType.sshSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceSshSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state(),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            versions = javaType.versions().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComputeInstanceVersionResponse.Companion.toKotlin(args0)
            }),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
