@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property failureReason The failure reason if the creation failed.
 * @property model Model used for the endpoint deployment.
 * @property provisioningState Read-only provision state status property.
 * @property raiPolicyName The name of RAI policy.
 * @property sku
 * @property type Kind of the deployment.
 * Expected value is 'Azure.ContentSafety'.
 * @property versionUpgradeOption Deployment model version upgrade option.
 */
public data class ContentSafetyEndpointDeploymentResourcePropertiesResponse(
    public val failureReason: String? = null,
    public val model: EndpointDeploymentModelResponse,
    public val provisioningState: String,
    public val raiPolicyName: String? = null,
    public val sku: CognitiveServicesSkuResponse? = null,
    public val type: String,
    public val versionUpgradeOption: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ContentSafetyEndpointDeploymentResourcePropertiesResponse):
            ContentSafetyEndpointDeploymentResourcePropertiesResponse =
            ContentSafetyEndpointDeploymentResourcePropertiesResponse(
                failureReason = javaType.failureReason().map({ args0 -> args0 }).orElse(null),
                model = javaType.model().let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EndpointDeploymentModelResponse.Companion.toKotlin(args0)
                }),
                provisioningState = javaType.provisioningState(),
                raiPolicyName = javaType.raiPolicyName().map({ args0 -> args0 }).orElse(null),
                sku = javaType.sku().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CognitiveServicesSkuResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
                versionUpgradeOption = javaType.versionUpgradeOption().map({ args0 -> args0 }).orElse(null),
            )
    }
}
