@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class to represent configuration settings for Docker Build
 * @property context Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
 * The path is relative to the asset path which must contain a single Blob URI value.
 * <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
 * @property dockerSpecificationType Enum to determine docker specification type. Must be either Build or Image.
 * Expected value is 'Build'.
 * @property dockerfile [Required] Docker command line instructions to assemble an image.
 * <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
 * @property platform The platform information of the docker image.
 */
public data class DockerBuildResponse(
    public val context: String? = null,
    public val dockerSpecificationType: String,
    public val dockerfile: String,
    public val platform: DockerImagePlatformResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.DockerBuildResponse):
            DockerBuildResponse = DockerBuildResponse(
            context = javaType.context().map({ args0 -> args0 }).orElse(null),
            dockerSpecificationType = javaType.dockerSpecificationType(),
            dockerfile = javaType.dockerfile(),
            platform = javaType.platform().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DockerImagePlatformResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
