@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property format Model format
 * @property name Model name.
 * @property source Optional. Deployment model source ARM resource ID.
 * @property version Model version.
 */
public data class EndpointDeploymentModelResponse(
    public val format: String? = null,
    public val name: String? = null,
    public val source: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.EndpointDeploymentModelResponse):
            EndpointDeploymentModelResponse = EndpointDeploymentModelResponse(
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
