@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Machine Learning dataset object wrapped into ARM resource envelope.
 * @property id Specifies the resource ID.
 * @property identity The identity of the resource.
 * @property location Specifies the location of the resource.
 * @property name Specifies the name of the resource.
 * @property properties Dataset properties
 * @property sku The sku of the workspace.
 * @property tags Contains resource tags defined as key/value pairs.
 * @property type Specifies the type of the resource.
 */
public data class GetMachineLearningDatasetResult(
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: DatasetResponse,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.GetMachineLearningDatasetResult):
            GetMachineLearningDatasetResult = GetMachineLearningDatasetResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
