@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property dockerArgs Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the system, or in this section. This parameter is only supported for Azure ML compute types.
 * @property instanceCount Optional number of instances or nodes used by the compute target.
 * @property instanceType Optional type of VM used as supported by the compute target.
 * @property properties Additional properties bag.
 * @property shmSize Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
 */
public data class JobResourceConfigurationResponse(
    public val dockerArgs: String? = null,
    public val instanceCount: Int? = null,
    public val instanceType: String? = null,
    public val properties: Map<String, Any>? = null,
    public val shmSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.JobResourceConfigurationResponse):
            JobResourceConfigurationResponse = JobResourceConfigurationResponse(
            dockerArgs = javaType.dockerArgs().map({ args0 -> args0 }).orElse(null),
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            shmSize = javaType.shmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
