@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Label category definition
 * @property classes Dictionary of label classes in this category.
 * @property displayName Display name of the label category.
 * @property multiSelect Indicates whether it is allowed to select multiple classes in this category.
 */
public data class LabelCategoryResponse(
    public val classes: Map<String, LabelClassResponse>? = null,
    public val displayName: String? = null,
    public val multiSelect: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LabelCategoryResponse):
            LabelCategoryResponse = LabelCategoryResponse(
            classes = javaType.classes().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelClassResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            multiSelect = javaType.multiSelect().map({ args0 -> args0 }).orElse(null),
        )
    }
}
