@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Job execution constraints.
 * @property maxConcurrentTrials Maximum Concurrent AutoML iterations.
 * @property maxTrials Number of AutoML iterations.
 * @property timeout AutoML job timeout.
 */
public data class NlpVerticalLimitSettingsResponse(
    public val maxConcurrentTrials: Int? = null,
    public val maxTrials: Int? = null,
    public val timeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.NlpVerticalLimitSettingsResponse):
            NlpVerticalLimitSettingsResponse = NlpVerticalLimitSettingsResponse(
            maxConcurrentTrials = javaType.maxConcurrentTrials().map({ args0 -> args0 }).orElse(null),
            maxTrials = javaType.maxTrials().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
