@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fqdn
 * @property notebookPreparationError The error that occurs when preparing notebook.
 * @property resourceId the data plane resourceId that used to initialize notebook component
 */
public data class NotebookResourceInfoResponse(
    public val fqdn: String? = null,
    public val notebookPreparationError: NotebookPreparationErrorResponse? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.NotebookResourceInfoResponse):
            NotebookResourceInfoResponse = NotebookResourceInfoResponse(
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            notebookPreparationError = javaType.notebookPreparationError().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NotebookPreparationErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
