@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private endpoint connection definition.
 * @property id This is the private endpoint connection name created on SRP
 * Full resource id: /subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.MachineLearningServices/{resourceType}/{resourceName}/privateEndpointConnections/{peConnectionName}
 * @property location Same as workspace location.
 * @property properties Properties of the Private Endpoint Connection
 */
public data class RegistryPrivateEndpointConnectionResponse(
    public val id: String? = null,
    public val location: String? = null,
    public val properties: RegistryPrivateEndpointConnectionPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RegistryPrivateEndpointConnectionResponse):
            RegistryPrivateEndpointConnectionResponse = RegistryPrivateEndpointConnectionResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RegistryPrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
