@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authMode Specifies the authentication mode for the Serverless endpoint.
 * @property capacityReservation Optional capacity reservation information for the endpoint. When specified, the Serverless Endpoint
 * will be allocated capacity from the specified capacity reservation group.
 * @property inferenceEndpoint The inference uri to target when making requests against the serverless endpoint
 * @property offer [Required] The publisher-defined Serverless Offer to provision the endpoint with.
 * @property provisioningState Provisioning state for the endpoint.
 */
public data class ServerlessEndpointResponse(
    public val authMode: String? = null,
    public val capacityReservation: ServerlessEndpointCapacityReservationResponse? = null,
    public val inferenceEndpoint: ServerlessInferenceEndpointResponse,
    public val offer: ServerlessOfferResponse,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ServerlessEndpointResponse):
            ServerlessEndpointResponse = ServerlessEndpointResponse(
            authMode = javaType.authMode().map({ args0 -> args0 }).orElse(null),
            capacityReservation = javaType.capacityReservation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ServerlessEndpointCapacityReservationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inferenceEndpoint = javaType.inferenceEndpoint().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ServerlessInferenceEndpointResponse.Companion.toKotlin(args0)
            }),
            offer = javaType.offer().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ServerlessOfferResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
