@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The resource model definition representing SKU
 * @property capacity If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here.
 * @property name The name of the SKU. Ex - P3. It is typically a letter+number code
 * @property size The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
 * @property tier This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
 */
public data class SkuResponse(
    public val capacity: Int? = null,
    public val family: String? = null,
    public val name: String,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
