@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A system service running on a compute.
 * @property publicIpAddress Public IP address
 * @property systemServiceType The type of this system service.
 * @property version The version for this type.
 */
public data class SystemServiceResponse(
    public val publicIpAddress: String,
    public val systemServiceType: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SystemServiceResponse):
            SystemServiceResponse = SystemServiceResponse(
            publicIpAddress = javaType.publicIpAddress(),
            systemServiceType = javaType.systemServiceType(),
            version = javaType.version(),
        )
    }
}
