@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Job execution constraints.
 * @property enableEarlyTermination Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
 * @property exitScore Exit score for the AutoML job.
 * @property maxConcurrentTrials Maximum Concurrent iterations.
 * @property maxCoresPerTrial Max cores per iteration.
 * @property maxTrials Number of iterations.
 * @property timeout AutoML job timeout.
 * @property trialTimeout Iteration timeout.
 */
public data class TableVerticalLimitSettingsResponse(
    public val enableEarlyTermination: Boolean? = null,
    public val exitScore: Double? = null,
    public val maxConcurrentTrials: Int? = null,
    public val maxCoresPerTrial: Int? = null,
    public val maxTrials: Int? = null,
    public val timeout: String? = null,
    public val trialTimeout: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.TableVerticalLimitSettingsResponse):
            TableVerticalLimitSettingsResponse = TableVerticalLimitSettingsResponse(
            enableEarlyTermination = javaType.enableEarlyTermination().map({ args0 -> args0 }).orElse(null),
            exitScore = javaType.exitScore().map({ args0 -> args0 }).orElse(null),
            maxConcurrentTrials = javaType.maxConcurrentTrials().map({ args0 -> args0 }).orElse(null),
            maxCoresPerTrial = javaType.maxCoresPerTrial().map({ args0 -> args0 }).orElse(null),
            maxTrials = javaType.maxTrials().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            trialTimeout = javaType.trialTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
