@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.kotlin.outputs.ConfigurationAssignmentFilterPropertiesResponse
import com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.maintenance.kotlin.outputs.ConfigurationAssignmentFilterPropertiesResponse.Companion.toKotlin as configurationAssignmentFilterPropertiesResponseToKotlin
import com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationAssignmentsForResourceGroup].
 */
@PulumiTagMarker
public class ConfigurationAssignmentsForResourceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationAssignmentsForResourceGroupArgs =
        ConfigurationAssignmentsForResourceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ConfigurationAssignmentsForResourceGroupArgsBuilder.() -> Unit) {
        val builder = ConfigurationAssignmentsForResourceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationAssignmentsForResourceGroup {
        val builtJavaResource =
            com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForResourceGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationAssignmentsForResourceGroup(builtJavaResource)
    }
}

/**
 * Configuration Assignment
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### ConfigurationAssignmentsForResourceGroup_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationAssignmentsForResourceGroup = new AzureNative.Maintenance.ConfigurationAssignmentsForResourceGroup("configurationAssignmentsForResourceGroup", new()
 *     {
 *         ConfigurationAssignmentName = "workervmConfiguration",
 *         Filter = new AzureNative.Maintenance.Inputs.ConfigurationAssignmentFilterPropertiesArgs
 *         {
 *             Locations = new[]
 *             {
 *                 "Japan East",
 *                 "UK South",
 *             },
 *             ResourceTypes = new[]
 *             {
 *                 "Microsoft.HybridCompute/machines",
 *                 "Microsoft.Compute/virtualMachines",
 *             },
 *             TagSettings = new AzureNative.Maintenance.Inputs.TagSettingsPropertiesArgs
 *             {
 *                 FilterOperator = AzureNative.Maintenance.TagOperators.Any,
 *                 Tags =
 *                 {
 *                     { "tag1", new[]
 *                     {
 *                         "tag1Value1",
 *                         "tag1Value2",
 *                         "tag1Value3",
 *                     } },
 *                     { "tag2", new[]
 *                     {
 *                         "tag2Value1",
 *                         "tag2Value2",
 *                         "tag2Value3",
 *                     } },
 *                 },
 *             },
 *         },
 *         MaintenanceConfigurationId = "/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maintenance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maintenance.NewConfigurationAssignmentsForResourceGroup(ctx, "configurationAssignmentsForResourceGroup", &maintenance.ConfigurationAssignmentsForResourceGroupArgs{
 * 			ConfigurationAssignmentName: pulumi.String("workervmConfiguration"),
 * 			Filter: &maintenance.ConfigurationAssignmentFilterPropertiesArgs{
 * 				Locations: pulumi.StringArray{
 * 					pulumi.String("Japan East"),
 * 					pulumi.String("UK South"),
 * 				},
 * 				ResourceTypes: pulumi.StringArray{
 * 					pulumi.String("Microsoft.HybridCompute/machines"),
 * 					pulumi.String("Microsoft.Compute/virtualMachines"),
 * 				},
 * 				TagSettings: &maintenance.TagSettingsPropertiesArgs{
 * 					FilterOperator: maintenance.TagOperatorsAny,
 * 					Tags: pulumi.StringArrayMap{
 * 						"tag1": pulumi.StringArray{
 * 							pulumi.String("tag1Value1"),
 * 							pulumi.String("tag1Value2"),
 * 							pulumi.String("tag1Value3"),
 * 						},
 * 						"tag2": pulumi.StringArray{
 * 							pulumi.String("tag2Value1"),
 * 							pulumi.String("tag2Value2"),
 * 							pulumi.String("tag2Value3"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			MaintenanceConfigurationId: pulumi.String("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1"),
 * 			ResourceGroupName:          pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForResourceGroup;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForResourceGroupArgs;
 * import com.pulumi.azurenative.maintenance.inputs.ConfigurationAssignmentFilterPropertiesArgs;
 * import com.pulumi.azurenative.maintenance.inputs.TagSettingsPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationAssignmentsForResourceGroup = new ConfigurationAssignmentsForResourceGroup("configurationAssignmentsForResourceGroup", ConfigurationAssignmentsForResourceGroupArgs.builder()
 *             .configurationAssignmentName("workervmConfiguration")
 *             .filter(ConfigurationAssignmentFilterPropertiesArgs.builder()
 *                 .locations(
 *                     "Japan East",
 *                     "UK South")
 *                 .resourceTypes(
 *                     "Microsoft.HybridCompute/machines",
 *                     "Microsoft.Compute/virtualMachines")
 *                 .tagSettings(TagSettingsPropertiesArgs.builder()
 *                     .filterOperator("Any")
 *                     .tags(Map.ofEntries(
 *                         Map.entry("tag1",
 *                             "tag1Value1",
 *                             "tag1Value2",
 *                             "tag1Value3"),
 *                         Map.entry("tag2",
 *                             "tag2Value1",
 *                             "tag2Value2",
 *                             "tag2Value3")
 *                     ))
 *                     .build())
 *                 .build())
 *             .maintenanceConfigurationId("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maintenance:ConfigurationAssignmentsForResourceGroup workervmConfiguration /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}
 * ```
 */
public class ConfigurationAssignmentsForResourceGroup internal constructor(
    override val javaResource:
    com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForResourceGroup,
) : KotlinCustomResource(javaResource, ConfigurationAssignmentsForResourceGroupMapper) {
    /**
     * Properties of the configuration assignment
     */
    public val filter: Output<ConfigurationAssignmentFilterPropertiesResponse>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    configurationAssignmentFilterPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Location of the resource
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maintenance configuration Id
     */
    public val maintenanceConfigurationId: Output<String>?
        get() = javaResource.maintenanceConfigurationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The unique resourceId
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Type of the resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationAssignmentsForResourceGroupMapper :
    ResourceMapper<ConfigurationAssignmentsForResourceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForResourceGroup::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationAssignmentsForResourceGroup =
        ConfigurationAssignmentsForResourceGroup(
            javaResource as
                com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForResourceGroup,
        )
}

/**
 * @see [ConfigurationAssignmentsForResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationAssignmentsForResourceGroup].
 */
public suspend fun configurationAssignmentsForResourceGroup(
    name: String,
    block: suspend ConfigurationAssignmentsForResourceGroupResourceBuilder.() -> Unit,
):
    ConfigurationAssignmentsForResourceGroup {
    val builder = ConfigurationAssignmentsForResourceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationAssignmentsForResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationAssignmentsForResourceGroup(name: String):
    ConfigurationAssignmentsForResourceGroup {
    val builder = ConfigurationAssignmentsForResourceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
