@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.MaintenanceOverridePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of a MaintenanceOverrideProperties
 * @property endDateTime Effective end date of the maintenance override window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
 * @property overrideProperties Gets or sets overrideProperties of the maintenanceConfiguration
 * @property startDateTime Effective start date of the maintenance override window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
 * @property timeZone Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
 */
public data class MaintenanceOverridePropertiesArgs(
    public val endDateTime: Output<String>? = null,
    public val overrideProperties: Output<Map<String, String>>? = null,
    public val startDateTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.MaintenanceOverridePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.maintenance.inputs.MaintenanceOverridePropertiesArgs =
        com.pulumi.azurenative.maintenance.inputs.MaintenanceOverridePropertiesArgs.builder()
            .endDateTime(endDateTime?.applyValue({ args0 -> args0 }))
            .overrideProperties(
                overrideProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .startDateTime(startDateTime?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceOverridePropertiesArgs].
 */
@PulumiTagMarker
public class MaintenanceOverridePropertiesArgsBuilder internal constructor() {
    private var endDateTime: Output<String>? = null

    private var overrideProperties: Output<Map<String, String>>? = null

    private var startDateTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Effective end date of the maintenance override window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
     */
    @JvmName("scmbhmvjsuvcphrd")
    public suspend fun endDateTime(`value`: Output<String>) {
        this.endDateTime = value
    }

    /**
     * @param value Gets or sets overrideProperties of the maintenanceConfiguration
     */
    @JvmName("afhmtnnebjlgaihs")
    public suspend fun overrideProperties(`value`: Output<Map<String, String>>) {
        this.overrideProperties = value
    }

    /**
     * @param value Effective start date of the maintenance override window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
     */
    @JvmName("iqscxcajlevcsumb")
    public suspend fun startDateTime(`value`: Output<String>) {
        this.startDateTime = value
    }

    /**
     * @param value Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
     */
    @JvmName("anmgurfhrblbefph")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Effective end date of the maintenance override window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
     */
    @JvmName("qagpwhmdvpsfhgwo")
    public suspend fun endDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDateTime = mapped
    }

    /**
     * @param value Gets or sets overrideProperties of the maintenanceConfiguration
     */
    @JvmName("mfijxtukydyfddfj")
    public suspend fun overrideProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideProperties = mapped
    }

    /**
     * @param values Gets or sets overrideProperties of the maintenanceConfiguration
     */
    @JvmName("puvqsykveyycwrco")
    public fun overrideProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrideProperties = mapped
    }

    /**
     * @param value Effective start date of the maintenance override window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
     */
    @JvmName("lgswjtpnexhthmie")
    public suspend fun startDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDateTime = mapped
    }

    /**
     * @param value Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
     */
    @JvmName("vmetjsmpabtbypmv")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): MaintenanceOverridePropertiesArgs = MaintenanceOverridePropertiesArgs(
        endDateTime = endDateTime,
        overrideProperties = overrideProperties,
        startDateTime = startDateTime,
        timeZone = timeZone,
    )
}
