@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.TaskPropertiesArgs.builder
import com.pulumi.azurenative.maintenance.kotlin.enums.TaskScope
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Task properties of the software update configuration.
 * @property parameters Gets or sets the parameters of the task.
 * @property source Gets or sets the name of the runbook.
 * @property taskScope Global Task execute once when schedule trigger. Resource task execute for each VM.
 */
public data class TaskPropertiesArgs(
    public val parameters: Output<Map<String, String>>? = null,
    public val source: Output<String>? = null,
    public val taskScope: Output<Either<String, TaskScope>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.TaskPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.maintenance.inputs.TaskPropertiesArgs =
        com.pulumi.azurenative.maintenance.inputs.TaskPropertiesArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .source(source?.applyValue({ args0 -> args0 }))
            .taskScope(
                taskScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [TaskPropertiesArgs].
 */
@PulumiTagMarker
public class TaskPropertiesArgsBuilder internal constructor() {
    private var parameters: Output<Map<String, String>>? = null

    private var source: Output<String>? = null

    private var taskScope: Output<Either<String, TaskScope>>? = null

    /**
     * @param value Gets or sets the parameters of the task.
     */
    @JvmName("yoohcgyalllqxadk")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Gets or sets the name of the runbook.
     */
    @JvmName("qnxlnuixwkxyqqfy")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Global Task execute once when schedule trigger. Resource task execute for each VM.
     */
    @JvmName("atanlwrmwvegyxeg")
    public suspend fun taskScope(`value`: Output<Either<String, TaskScope>>) {
        this.taskScope = value
    }

    /**
     * @param value Gets or sets the parameters of the task.
     */
    @JvmName("kcuwxxoioufculnf")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Gets or sets the parameters of the task.
     */
    @JvmName("hvgvvgqmqwaobjrr")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Gets or sets the name of the runbook.
     */
    @JvmName("guppvoacqveiumal")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Global Task execute once when schedule trigger. Resource task execute for each VM.
     */
    @JvmName("muaymqbyxcqtacjk")
    public suspend fun taskScope(`value`: Either<String, TaskScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskScope = mapped
    }

    /**
     * @param value Global Task execute once when schedule trigger. Resource task execute for each VM.
     */
    @JvmName("fjevvbkarckuahte")
    public fun taskScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TaskScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskScope = mapped
    }

    /**
     * @param value Global Task execute once when schedule trigger. Resource task execute for each VM.
     */
    @JvmName("ywqubdcpcxehqtoy")
    public fun taskScope(`value`: TaskScope) {
        val toBeMapped = Either.ofRight<String, TaskScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskScope = mapped
    }

    internal fun build(): TaskPropertiesArgs = TaskPropertiesArgs(
        parameters = parameters,
        source = source,
        taskScope = taskScope,
    )
}
