@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure query for the update configuration.
 * @property locations List of locations to scope the query to.
 * @property osTypes List of allowed operating systems.
 * @property resourceGroups List of allowed resource groups.
 * @property resourceTypes List of allowed resources.
 * @property tagSettings Tag settings for the VM.
 */
public data class ConfigurationAssignmentFilterPropertiesResponse(
    public val locations: List<String>? = null,
    public val osTypes: List<String>? = null,
    public val resourceGroups: List<String>? = null,
    public val resourceTypes: List<String>? = null,
    public val tagSettings: TagSettingsPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.maintenance.outputs.ConfigurationAssignmentFilterPropertiesResponse):
            ConfigurationAssignmentFilterPropertiesResponse =
            ConfigurationAssignmentFilterPropertiesResponse(
                locations = javaType.locations().map({ args0 -> args0 }),
                osTypes = javaType.osTypes().map({ args0 -> args0 }),
                resourceGroups = javaType.resourceGroups().map({ args0 -> args0 }),
                resourceTypes = javaType.resourceTypes().map({ args0 -> args0 }),
                tagSettings = javaType.tagSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.maintenance.kotlin.outputs.TagSettingsPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
