@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input configuration for a patch run
 * @property linuxParameters Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
 * @property postTasks List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
 * @property preTasks List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
 * @property rebootSetting Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed.
 * @property windowsParameters Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
 */
public data class InputPatchConfigurationResponse(
    public val linuxParameters: InputLinuxParametersResponse? = null,
    public val postTasks: List<TaskPropertiesResponse>? = null,
    public val preTasks: List<TaskPropertiesResponse>? = null,
    public val rebootSetting: String? = null,
    public val windowsParameters: InputWindowsParametersResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.maintenance.outputs.InputPatchConfigurationResponse):
            InputPatchConfigurationResponse = InputPatchConfigurationResponse(
            linuxParameters = javaType.linuxParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.maintenance.kotlin.outputs.InputLinuxParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            postTasks = javaType.postTasks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.maintenance.kotlin.outputs.TaskPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            preTasks = javaType.preTasks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.maintenance.kotlin.outputs.TaskPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            rebootSetting = javaType.rebootSetting().map({ args0 -> args0 }).orElse(null),
            windowsParameters = javaType.windowsParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.maintenance.kotlin.outputs.InputWindowsParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
