@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicyArgs.builder
import com.pulumi.azurenative.managednetwork.kotlin.inputs.ManagedNetworkPeeringPolicyPropertiesArgs
import com.pulumi.azurenative.managednetwork.kotlin.inputs.ManagedNetworkPeeringPolicyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Managed Network Peering Policy resource
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### ManagedNetworkPeeringPoliciesPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedNetworkPeeringPolicy = new AzureNative.ManagedNetwork.ManagedNetworkPeeringPolicy("managedNetworkPeeringPolicy", new()
 *     {
 *         ManagedNetworkName = "myManagedNetwork",
 *         ManagedNetworkPeeringPolicyName = "myHubAndSpoke",
 *         Properties = new AzureNative.ManagedNetwork.Inputs.ManagedNetworkPeeringPolicyPropertiesArgs
 *         {
 *             Hub = new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *             {
 *                 Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myHubVnet",
 *             },
 *             Spokes = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork/managedNetworkGroups/myManagedNetworkGroup1",
 *                 },
 *             },
 *             Type = AzureNative.ManagedNetwork.Type.HubAndSpokeTopology,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetwork.NewManagedNetworkPeeringPolicy(ctx, "managedNetworkPeeringPolicy", &managednetwork.ManagedNetworkPeeringPolicyArgs{
 * 			ManagedNetworkName:              pulumi.String("myManagedNetwork"),
 * 			ManagedNetworkPeeringPolicyName: pulumi.String("myHubAndSpoke"),
 * 			Properties: &managednetwork.ManagedNetworkPeeringPolicyPropertiesArgs{
 * 				Hub: &managednetwork.ResourceIdArgs{
 * 					Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myHubVnet"),
 * 				},
 * 				Spokes: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork/managedNetworkGroups/myManagedNetworkGroup1"),
 * 					},
 * 				},
 * 				Type: pulumi.String(managednetwork.TypeHubAndSpokeTopology),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicy;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicyArgs;
 * import com.pulumi.azurenative.managednetwork.inputs.ManagedNetworkPeeringPolicyPropertiesArgs;
 * import com.pulumi.azurenative.managednetwork.inputs.ResourceIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedNetworkPeeringPolicy = new ManagedNetworkPeeringPolicy("managedNetworkPeeringPolicy", ManagedNetworkPeeringPolicyArgs.builder()
 *             .managedNetworkName("myManagedNetwork")
 *             .managedNetworkPeeringPolicyName("myHubAndSpoke")
 *             .properties(ManagedNetworkPeeringPolicyPropertiesArgs.builder()
 *                 .hub(ResourceIdArgs.builder()
 *                     .id("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myHubVnet")
 *                     .build())
 *                 .spokes(ResourceIdArgs.builder()
 *                     .id("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork/managedNetworkGroups/myManagedNetworkGroup1")
 *                     .build())
 *                 .type("HubAndSpokeTopology")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetwork:ManagedNetworkPeeringPolicy myHubAndSpoke /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}/managedNetworkPeeringPolicies/{managedNetworkPeeringPolicyName}
 * ```
 * @property location The geo-location where the resource lives
 * @property managedNetworkName The name of the Managed Network.
 * @property managedNetworkPeeringPolicyName The name of the Managed Network Peering Policy.
 * @property properties Gets or sets the properties of a Managed Network Policy
 * @property resourceGroupName The name of the resource group.
 */
public data class ManagedNetworkPeeringPolicyArgs(
    public val location: Output<String>? = null,
    public val managedNetworkName: Output<String>? = null,
    public val managedNetworkPeeringPolicyName: Output<String>? = null,
    public val properties: Output<ManagedNetworkPeeringPolicyPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicyArgs =
        com.pulumi.azurenative.managednetwork.ManagedNetworkPeeringPolicyArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .managedNetworkName(managedNetworkName?.applyValue({ args0 -> args0 }))
            .managedNetworkPeeringPolicyName(managedNetworkPeeringPolicyName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedNetworkPeeringPolicyArgs].
 */
@PulumiTagMarker
public class ManagedNetworkPeeringPolicyArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var managedNetworkName: Output<String>? = null

    private var managedNetworkPeeringPolicyName: Output<String>? = null

    private var properties: Output<ManagedNetworkPeeringPolicyPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("twsnaabwpqqxmuwt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("aixfpctidhmbwwuw")
    public suspend fun managedNetworkName(`value`: Output<String>) {
        this.managedNetworkName = value
    }

    /**
     * @param value The name of the Managed Network Peering Policy.
     */
    @JvmName("nbqhtgwgsdjlhnyo")
    public suspend fun managedNetworkPeeringPolicyName(`value`: Output<String>) {
        this.managedNetworkPeeringPolicyName = value
    }

    /**
     * @param value Gets or sets the properties of a Managed Network Policy
     */
    @JvmName("xbvvwxxscwydtohv")
    public suspend fun properties(`value`: Output<ManagedNetworkPeeringPolicyPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("myfscpaffghpqlbp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ngnbcafotqcvqtiv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("wybsljvboqtmsgdu")
    public suspend fun managedNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedNetworkName = mapped
    }

    /**
     * @param value The name of the Managed Network Peering Policy.
     */
    @JvmName("bqrrmblesyrrwjde")
    public suspend fun managedNetworkPeeringPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedNetworkPeeringPolicyName = mapped
    }

    /**
     * @param value Gets or sets the properties of a Managed Network Policy
     */
    @JvmName("wnxjxscbfowoqomn")
    public suspend fun properties(`value`: ManagedNetworkPeeringPolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Gets or sets the properties of a Managed Network Policy
     */
    @JvmName("jexqaqdwprcundkg")
    public suspend
    fun properties(argument: suspend ManagedNetworkPeeringPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedNetworkPeeringPolicyPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jsrexemvobbxaafh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagedNetworkPeeringPolicyArgs = ManagedNetworkPeeringPolicyArgs(
        location = location,
        managedNetworkName = managedNetworkName,
        managedNetworkPeeringPolicyName = managedNetworkPeeringPolicyName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
