@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.inputs

import com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managedNetworkGroupName The name of the Managed Network Group.
 * @property managedNetworkName The name of the Managed Network.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetManagedNetworkGroupPlainArgs(
    public val managedNetworkGroupName: String,
    public val managedNetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkGroupPlainArgs =
        com.pulumi.azurenative.managednetwork.inputs.GetManagedNetworkGroupPlainArgs.builder()
            .managedNetworkGroupName(managedNetworkGroupName.let({ args0 -> args0 }))
            .managedNetworkName(managedNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedNetworkGroupPlainArgs].
 */
@PulumiTagMarker
public class GetManagedNetworkGroupPlainArgsBuilder internal constructor() {
    private var managedNetworkGroupName: String? = null

    private var managedNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Managed Network Group.
     */
    @JvmName("cjtoyyhwmdotkoiy")
    public suspend fun managedNetworkGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedNetworkGroupName = mapped
    }

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("cctvkfoffdnavqfr")
    public suspend fun managedNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedNetworkName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xnxcxyouaxkmpskj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedNetworkGroupPlainArgs = GetManagedNetworkGroupPlainArgs(
        managedNetworkGroupName = managedNetworkGroupName ?: throw
            PulumiNullFieldException("managedNetworkGroupName"),
        managedNetworkName = managedNetworkName ?: throw PulumiNullFieldException("managedNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
