@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.inputs

import com.pulumi.azurenative.managednetwork.inputs.GetScopeAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scope The base resource of the scope assignment.
 * @property scopeAssignmentName The name of the scope assignment to get.
 */
public data class GetScopeAssignmentPlainArgs(
    public val scope: String,
    public val scopeAssignmentName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.inputs.GetScopeAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetwork.inputs.GetScopeAssignmentPlainArgs =
        com.pulumi.azurenative.managednetwork.inputs.GetScopeAssignmentPlainArgs.builder()
            .scope(scope.let({ args0 -> args0 }))
            .scopeAssignmentName(scopeAssignmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScopeAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetScopeAssignmentPlainArgsBuilder internal constructor() {
    private var scope: String? = null

    private var scopeAssignmentName: String? = null

    /**
     * @param value The base resource of the scope assignment.
     */
    @JvmName("fnncgwurqmxymcst")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    /**
     * @param value The name of the scope assignment to get.
     */
    @JvmName("mpgtndpfwlkcausr")
    public suspend fun scopeAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopeAssignmentName = mapped
    }

    internal fun build(): GetScopeAssignmentPlainArgs = GetScopeAssignmentPlainArgs(
        scope = scope ?: throw PulumiNullFieldException("scope"),
        scopeAssignmentName = scopeAssignmentName ?: throw PulumiNullFieldException("scopeAssignmentName"),
    )
}
