@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a Managed Network Peering Policy
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hub Gets or sets the hub virtual network ID
 * @property mesh Gets or sets the mesh group IDs
 * @property provisioningState Provisioning state of the ManagedNetwork resource.
 * @property spokes Gets or sets the spokes group IDs
 * @property type Gets or sets the connectivity type of a network structure policy
 */
public data class ManagedNetworkPeeringPolicyPropertiesResponse(
    public val etag: String,
    public val hub: ResourceIdResponse? = null,
    public val mesh: List<ResourceIdResponse>? = null,
    public val provisioningState: String,
    public val spokes: List<ResourceIdResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetwork.outputs.ManagedNetworkPeeringPolicyPropertiesResponse):
            ManagedNetworkPeeringPolicyPropertiesResponse =
            ManagedNetworkPeeringPolicyPropertiesResponse(
                etag = javaType.etag(),
                hub = javaType.hub().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                mesh = javaType.mesh().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                    })
                }),
                provisioningState = javaType.provisioningState(),
                spokes = javaType.spokes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                    })
                }),
                type = javaType.type(),
            )
    }
}
