@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Scope of a Managed Network
 * @property managementGroups The collection of management groups covered by the Managed Network
 * @property subnets The collection of  subnets covered by the Managed Network
 * @property subscriptions The collection of subscriptions covered by the Managed Network
 * @property virtualNetworks The collection of virtual nets covered by the Managed Network
 */
public data class ScopeResponse(
    public val managementGroups: List<ResourceIdResponse>? = null,
    public val subnets: List<ResourceIdResponse>? = null,
    public val subscriptions: List<ResourceIdResponse>? = null,
    public val virtualNetworks: List<ResourceIdResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetwork.outputs.ScopeResponse):
            ScopeResponse = ScopeResponse(
            managementGroups = javaType.managementGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            subscriptions = javaType.subscriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            virtualNetworks = javaType.virtualNetworks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetwork.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
