@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.ExternalNetworkArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.PeeringOption
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ExternalNetworkPropertiesOptionAPropertiesArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ExternalNetworkPropertiesOptionAPropertiesArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.OptionBPropertiesArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.OptionBPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the ExternalNetwork item.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### ExternalNetworks_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var externalNetwork = new AzureNative.ManagedNetworkFabric.ExternalNetwork("externalNetwork", new()
 *     {
 *         ExportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName",
 *         ExternalNetworkName = "example-externalnetwork",
 *         ImportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName",
 *         L3IsolationDomainName = "example-l3domain",
 *         OptionAProperties = new AzureNative.ManagedNetworkFabric.Inputs.ExternalNetworkPropertiesOptionAPropertiesArgs
 *         {
 *             Mtu = 1500,
 *             PeerASN = 65047,
 *             PrimaryIpv4Prefix = "10.1.1.0/30",
 *             PrimaryIpv6Prefix = "3FFE:FFFF:0:CD30::a0/126",
 *             SecondaryIpv4Prefix = "10.1.1.4/30",
 *             SecondaryIpv6Prefix = "3FFE:FFFF:0:CD30::a4/126",
 *             VlanId = 1001,
 *         },
 *         OptionBProperties = new AzureNative.ManagedNetworkFabric.Inputs.OptionBPropertiesArgs
 *         {
 *             ExportRouteTargets = new[]
 *             {
 *                 "65046:10039",
 *             },
 *             ImportRouteTargets = new[]
 *             {
 *                 "65046:10039",
 *             },
 *         },
 *         PeeringOption = AzureNative.ManagedNetworkFabric.PeeringOption.OptionA,
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewExternalNetwork(ctx, "externalNetwork", &managednetworkfabric.ExternalNetworkArgs{
 * 			ExportRoutePolicyId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName"),
 * 			ExternalNetworkName:   pulumi.String("example-externalnetwork"),
 * 			ImportRoutePolicyId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName"),
 * 			L3IsolationDomainName: pulumi.String("example-l3domain"),
 * 			OptionAProperties: &managednetworkfabric.ExternalNetworkPropertiesOptionAPropertiesArgs{
 * 				Mtu:                 pulumi.Int(1500),
 * 				PeerASN:             pulumi.Int(65047),
 * 				PrimaryIpv4Prefix:   pulumi.String("10.1.1.0/30"),
 * 				PrimaryIpv6Prefix:   pulumi.String("3FFE:FFFF:0:CD30::a0/126"),
 * 				SecondaryIpv4Prefix: pulumi.String("10.1.1.4/30"),
 * 				SecondaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::a4/126"),
 * 				VlanId:              pulumi.Int(1001),
 * 			},
 * 			OptionBProperties: &managednetworkfabric.OptionBPropertiesArgs{
 * 				ExportRouteTargets: pulumi.StringArray{
 * 					pulumi.String("65046:10039"),
 * 				},
 * 				ImportRouteTargets: pulumi.StringArray{
 * 					pulumi.String("65046:10039"),
 * 				},
 * 			},
 * 			PeeringOption:     pulumi.String(managednetworkfabric.PeeringOptionOptionA),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.ExternalNetwork;
 * import com.pulumi.azurenative.managednetworkfabric.ExternalNetworkArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.ExternalNetworkPropertiesOptionAPropertiesArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.OptionBPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var externalNetwork = new ExternalNetwork("externalNetwork", ExternalNetworkArgs.builder()
 *             .exportRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName")
 *             .externalNetworkName("example-externalnetwork")
 *             .importRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName")
 *             .l3IsolationDomainName("example-l3domain")
 *             .optionAProperties(ExternalNetworkPropertiesOptionAPropertiesArgs.builder()
 *                 .mtu(1500)
 *                 .peerASN(65047)
 *                 .primaryIpv4Prefix("10.1.1.0/30")
 *                 .primaryIpv6Prefix("3FFE:FFFF:0:CD30::a0/126")
 *                 .secondaryIpv4Prefix("10.1.1.4/30")
 *                 .secondaryIpv6Prefix("3FFE:FFFF:0:CD30::a4/126")
 *                 .vlanId(1001)
 *                 .build())
 *             .optionBProperties(OptionBPropertiesArgs.builder()
 *                 .exportRouteTargets("65046:10039")
 *                 .importRouteTargets("65046:10039")
 *                 .build())
 *             .peeringOption("OptionA")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:ExternalNetwork example-externalnetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/{l3IsolationDomainName}/externalNetworks/{externalNetworkName}
 * ```
 * @property annotation Switch configuration description.
 * @property exportRoutePolicyId ARM resource ID of exportRoutePolicy.
 * @property externalNetworkName Name of the ExternalNetwork
 * @property importRoutePolicyId ARM resource ID of importRoutePolicy.
 * @property l3IsolationDomainName Name of the L3IsolationDomain
 * @property optionAProperties option A properties object
 * @property optionBProperties option B properties object
 * @property peeringOption Peering option list.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ExternalNetworkArgs(
    public val `annotation`: Output<String>? = null,
    public val exportRoutePolicyId: Output<String>? = null,
    public val externalNetworkName: Output<String>? = null,
    public val importRoutePolicyId: Output<String>? = null,
    public val l3IsolationDomainName: Output<String>? = null,
    public val optionAProperties: Output<ExternalNetworkPropertiesOptionAPropertiesArgs>? = null,
    public val optionBProperties: Output<OptionBPropertiesArgs>? = null,
    public val peeringOption: Output<Either<String, PeeringOption>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.ExternalNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.ExternalNetworkArgs =
        com.pulumi.azurenative.managednetworkfabric.ExternalNetworkArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .exportRoutePolicyId(exportRoutePolicyId?.applyValue({ args0 -> args0 }))
            .externalNetworkName(externalNetworkName?.applyValue({ args0 -> args0 }))
            .importRoutePolicyId(importRoutePolicyId?.applyValue({ args0 -> args0 }))
            .l3IsolationDomainName(l3IsolationDomainName?.applyValue({ args0 -> args0 }))
            .optionAProperties(optionAProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .optionBProperties(optionBProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .peeringOption(
                peeringOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExternalNetworkArgs].
 */
@PulumiTagMarker
public class ExternalNetworkArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var exportRoutePolicyId: Output<String>? = null

    private var externalNetworkName: Output<String>? = null

    private var importRoutePolicyId: Output<String>? = null

    private var l3IsolationDomainName: Output<String>? = null

    private var optionAProperties: Output<ExternalNetworkPropertiesOptionAPropertiesArgs>? = null

    private var optionBProperties: Output<OptionBPropertiesArgs>? = null

    private var peeringOption: Output<Either<String, PeeringOption>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("skvevwphkcjbitan")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value ARM resource ID of exportRoutePolicy.
     */
    @JvmName("xjdqjqyawmnkxjvv")
    public suspend fun exportRoutePolicyId(`value`: Output<String>) {
        this.exportRoutePolicyId = value
    }

    /**
     * @param value Name of the ExternalNetwork
     */
    @JvmName("yfewxvysggyousby")
    public suspend fun externalNetworkName(`value`: Output<String>) {
        this.externalNetworkName = value
    }

    /**
     * @param value ARM resource ID of importRoutePolicy.
     */
    @JvmName("tnqtbahwgfmanbsb")
    public suspend fun importRoutePolicyId(`value`: Output<String>) {
        this.importRoutePolicyId = value
    }

    /**
     * @param value Name of the L3IsolationDomain
     */
    @JvmName("wudtbiylxpgvehbr")
    public suspend fun l3IsolationDomainName(`value`: Output<String>) {
        this.l3IsolationDomainName = value
    }

    /**
     * @param value option A properties object
     */
    @JvmName("jabyowljysnddtlt")
    public suspend
    fun optionAProperties(`value`: Output<ExternalNetworkPropertiesOptionAPropertiesArgs>) {
        this.optionAProperties = value
    }

    /**
     * @param value option B properties object
     */
    @JvmName("iadvsfycqdtldlhl")
    public suspend fun optionBProperties(`value`: Output<OptionBPropertiesArgs>) {
        this.optionBProperties = value
    }

    /**
     * @param value Peering option list.
     */
    @JvmName("qayorcmdopfsfycx")
    public suspend fun peeringOption(`value`: Output<Either<String, PeeringOption>>) {
        this.peeringOption = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uwckdygwmicragat")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("pmhylumkhdnuxawv")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value ARM resource ID of exportRoutePolicy.
     */
    @JvmName("ycgmwjyfwwcchccw")
    public suspend fun exportRoutePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportRoutePolicyId = mapped
    }

    /**
     * @param value Name of the ExternalNetwork
     */
    @JvmName("uanygmtgmbdigxoy")
    public suspend fun externalNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalNetworkName = mapped
    }

    /**
     * @param value ARM resource ID of importRoutePolicy.
     */
    @JvmName("hjoawmnohbdvefod")
    public suspend fun importRoutePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importRoutePolicyId = mapped
    }

    /**
     * @param value Name of the L3IsolationDomain
     */
    @JvmName("bqeqcejwjskgxkcp")
    public suspend fun l3IsolationDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l3IsolationDomainName = mapped
    }

    /**
     * @param value option A properties object
     */
    @JvmName("daerlyilnysvuatx")
    public suspend fun optionAProperties(`value`: ExternalNetworkPropertiesOptionAPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionAProperties = mapped
    }

    /**
     * @param argument option A properties object
     */
    @JvmName("vtsluqngfmurljwq")
    public suspend
    fun optionAProperties(argument: suspend ExternalNetworkPropertiesOptionAPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ExternalNetworkPropertiesOptionAPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.optionAProperties = mapped
    }

    /**
     * @param value option B properties object
     */
    @JvmName("gqwkuvvkhyrfrorr")
    public suspend fun optionBProperties(`value`: OptionBPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionBProperties = mapped
    }

    /**
     * @param argument option B properties object
     */
    @JvmName("mcygbqivjpnclwtc")
    public suspend fun optionBProperties(argument: suspend OptionBPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = OptionBPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.optionBProperties = mapped
    }

    /**
     * @param value Peering option list.
     */
    @JvmName("glbyscephqweimnd")
    public suspend fun peeringOption(`value`: Either<String, PeeringOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringOption = mapped
    }

    /**
     * @param value Peering option list.
     */
    @JvmName("gktyuvvoviirmtvu")
    public fun peeringOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PeeringOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringOption = mapped
    }

    /**
     * @param value Peering option list.
     */
    @JvmName("tghrqqsabvctlmdg")
    public fun peeringOption(`value`: PeeringOption) {
        val toBeMapped = Either.ofRight<String, PeeringOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringOption = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rmlgioamkudkfcxt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ExternalNetworkArgs = ExternalNetworkArgs(
        `annotation` = `annotation`,
        exportRoutePolicyId = exportRoutePolicyId,
        externalNetworkName = externalNetworkName,
        importRoutePolicyId = importRoutePolicyId,
        l3IsolationDomainName = l3IsolationDomainName,
        optionAProperties = optionAProperties,
        optionBProperties = optionBProperties,
        peeringOption = peeringOption,
        resourceGroupName = resourceGroupName,
    )
}
