@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.BgpConfigurationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ConnectedSubnetResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.StaticRouteConfigurationResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.BgpConfigurationResponse.Companion.toKotlin as bgpConfigurationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ConnectedSubnetResponse.Companion.toKotlin as connectedSubnetResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.StaticRouteConfigurationResponse.Companion.toKotlin as staticRouteConfigurationResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [InternalNetwork].
 */
@PulumiTagMarker
public class InternalNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InternalNetworkArgs = InternalNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InternalNetworkArgsBuilder.() -> Unit) {
        val builder = InternalNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InternalNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.InternalNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InternalNetwork(builtJavaResource)
    }
}

/**
 * Defines the InternalNetwork item.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### InternalNetworks_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var internalNetwork = new AzureNative.ManagedNetworkFabric.InternalNetwork("internalNetwork", new()
 *     {
 *         BgpConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.BgpConfigurationArgs
 *         {
 *             AllowAS = 1,
 *             AllowASOverride = AzureNative.ManagedNetworkFabric.AllowASOverride.Enable,
 *             DefaultRouteOriginate = AzureNative.ManagedNetworkFabric.BooleanEnumProperty.True,
 *             Ipv4ListenRangePrefixes = new[]
 *             {
 *                 "10.1.0.0/25",
 *             },
 *             Ipv4NeighborAddress = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.NeighborAddressArgs
 *                 {
 *                     Address = "10.1.0.0",
 *                 },
 *             },
 *             Ipv6ListenRangePrefixes = new[]
 *             {
 *                 "2fff::/66",
 *             },
 *             Ipv6NeighborAddress = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.NeighborAddressArgs
 *                 {
 *                     Address = "2fff::",
 *                 },
 *             },
 *             PeerASN = 6,
 *         },
 *         ConnectedIPv4Subnets = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.ConnectedSubnetArgs
 *             {
 *                 Prefix = "10.0.0.0/24",
 *             },
 *         },
 *         ConnectedIPv6Subnets = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.ConnectedSubnetArgs
 *             {
 *                 Prefix = "3FFE:FFFF:0:CD30::a0/29",
 *             },
 *         },
 *         ExportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2",
 *         ImportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1",
 *         InternalNetworkName = "example-internalnetwork",
 *         L3IsolationDomainName = "example-l3domain",
 *         Mtu = 1500,
 *         ResourceGroupName = "resourceGroupName",
 *         StaticRouteConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.StaticRouteConfigurationArgs
 *         {
 *             Ipv4Routes = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.StaticRoutePropertiesArgs
 *                 {
 *                     NextHop = new[]
 *                     {
 *                         "10.0.0.1",
 *                     },
 *                     Prefix = "10.1.0.0/24",
 *                 },
 *             },
 *             Ipv6Routes = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.StaticRoutePropertiesArgs
 *                 {
 *                     NextHop = new[]
 *                     {
 *                         "2ffe::1",
 *                     },
 *                     Prefix = "2fff::/64",
 *                 },
 *             },
 *         },
 *         VlanId = 501,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewInternalNetwork(ctx, "internalNetwork", &managednetworkfabric.InternalNetworkArgs{
 * 			BgpConfiguration: &managednetworkfabric.BgpConfigurationArgs{
 * 				AllowAS:               pulumi.Int(1),
 * 				AllowASOverride:       pulumi.String(managednetworkfabric.AllowASOverrideEnable),
 * 				DefaultRouteOriginate: pulumi.String(managednetworkfabric.BooleanEnumPropertyTrue),
 * 				Ipv4ListenRangePrefixes: pulumi.StringArray{
 * 					pulumi.String("10.1.0.0/25"),
 * 				},
 * 				Ipv4NeighborAddress: managednetworkfabric.NeighborAddressArray{
 * 					&managednetworkfabric.NeighborAddressArgs{
 * 						Address: pulumi.String("10.1.0.0"),
 * 					},
 * 				},
 * 				Ipv6ListenRangePrefixes: pulumi.StringArray{
 * 					pulumi.String("2fff::/66"),
 * 				},
 * 				Ipv6NeighborAddress: managednetworkfabric.NeighborAddressArray{
 * 					&managednetworkfabric.NeighborAddressArgs{
 * 						Address: pulumi.String("2fff::"),
 * 					},
 * 				},
 * 				PeerASN: pulumi.Int(6),
 * 			},
 * 			ConnectedIPv4Subnets: managednetworkfabric.ConnectedSubnetArray{
 * 				&managednetworkfabric.ConnectedSubnetArgs{
 * 					Prefix: pulumi.String("10.0.0.0/24"),
 * 				},
 * 			},
 * 			ConnectedIPv6Subnets: managednetworkfabric.ConnectedSubnetArray{
 * 				&managednetworkfabric.ConnectedSubnetArgs{
 * 					Prefix: pulumi.String("3FFE:FFFF:0:CD30::a0/29"),
 * 				},
 * 			},
 * 			ExportRoutePolicyId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2"),
 * 			ImportRoutePolicyId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1"),
 * 			InternalNetworkName:   pulumi.String("example-internalnetwork"),
 * 			L3IsolationDomainName: pulumi.String("example-l3domain"),
 * 			Mtu:                   pulumi.Int(1500),
 * 			ResourceGroupName:     pulumi.String("resourceGroupName"),
 * 			StaticRouteConfiguration: &managednetworkfabric.StaticRouteConfigurationArgs{
 * 				Ipv4Routes: managednetworkfabric.StaticRoutePropertiesArray{
 * 					&managednetworkfabric.StaticRoutePropertiesArgs{
 * 						NextHop: pulumi.StringArray{
 * 							pulumi.String("10.0.0.1"),
 * 						},
 * 						Prefix: pulumi.String("10.1.0.0/24"),
 * 					},
 * 				},
 * 				Ipv6Routes: managednetworkfabric.StaticRoutePropertiesArray{
 * 					&managednetworkfabric.StaticRoutePropertiesArgs{
 * 						NextHop: pulumi.StringArray{
 * 							pulumi.String("2ffe::1"),
 * 						},
 * 						Prefix: pulumi.String("2fff::/64"),
 * 					},
 * 				},
 * 			},
 * 			VlanId: pulumi.Int(501),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.InternalNetwork;
 * import com.pulumi.azurenative.managednetworkfabric.InternalNetworkArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.BgpConfigurationArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.ConnectedSubnetArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.StaticRouteConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var internalNetwork = new InternalNetwork("internalNetwork", InternalNetworkArgs.builder()
 *             .bgpConfiguration(BgpConfigurationArgs.builder()
 *                 .allowAS(1)
 *                 .allowASOverride("Enable")
 *                 .defaultRouteOriginate("True")
 *                 .ipv4ListenRangePrefixes("10.1.0.0/25")
 *                 .ipv4NeighborAddress(NeighborAddressArgs.builder()
 *                     .address("10.1.0.0")
 *                     .build())
 *                 .ipv6ListenRangePrefixes("2fff::/66")
 *                 .ipv6NeighborAddress(NeighborAddressArgs.builder()
 *                     .address("2fff::")
 *                     .build())
 *                 .peerASN(6)
 *                 .build())
 *             .connectedIPv4Subnets(ConnectedSubnetArgs.builder()
 *                 .prefix("10.0.0.0/24")
 *                 .build())
 *             .connectedIPv6Subnets(ConnectedSubnetArgs.builder()
 *                 .prefix("3FFE:FFFF:0:CD30::a0/29")
 *                 .build())
 *             .exportRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2")
 *             .importRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1")
 *             .internalNetworkName("example-internalnetwork")
 *             .l3IsolationDomainName("example-l3domain")
 *             .mtu(1500)
 *             .resourceGroupName("resourceGroupName")
 *             .staticRouteConfiguration(StaticRouteConfigurationArgs.builder()
 *                 .ipv4Routes(StaticRoutePropertiesArgs.builder()
 *                     .nextHop("10.0.0.1")
 *                     .prefix("10.1.0.0/24")
 *                     .build())
 *                 .ipv6Routes(StaticRoutePropertiesArgs.builder()
 *                     .nextHop("2ffe::1")
 *                     .prefix("2fff::/64")
 *                     .build())
 *                 .build())
 *             .vlanId(501)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:InternalNetwork example-externalnetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/{l3IsolationDomainName}/internalNetworks/{internalNetworkName}
 * ```
 */
public class InternalNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.InternalNetwork,
) : KotlinCustomResource(javaResource, InternalNetworkMapper) {
    /**
     * Administrative state of the InternalNetwork. Example: Enabled | Disabled.
     */
    public val administrativeState: Output<String>
        get() = javaResource.administrativeState().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of resources the BFD for BGP is disabled on. Can be either entire NetworkFabric or NetworkRack.
     */
    public val bfdDisabledOnResources: Output<List<String>>
        get() = javaResource.bfdDisabledOnResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of resources the BFD of StaticRoutes is disabled on. Can be either entire NetworkFabric or NetworkRack.
     */
    public val bfdForStaticRoutesDisabledOnResources: Output<List<String>>
        get() = javaResource.bfdForStaticRoutesDisabledOnResources().applyValue({ args0 ->
            args0.map({ args0 -> args0 })
        })

    /**
     * BGP configuration properties
     */
    public val bgpConfiguration: Output<BgpConfigurationResponse>?
        get() = javaResource.bgpConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bgpConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of resources the BGP is disabled on. Can be either entire NetworkFabric or NetworkRack.
     */
    public val bgpDisabledOnResources: Output<List<String>>
        get() = javaResource.bgpDisabledOnResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List with object connected IPv4 Subnets.
     */
    public val connectedIPv4Subnets: Output<List<ConnectedSubnetResponse>>?
        get() = javaResource.connectedIPv4Subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        connectedSubnetResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List with object connected IPv6 Subnets.
     */
    public val connectedIPv6Subnets: Output<List<ConnectedSubnetResponse>>?
        get() = javaResource.connectedIPv6Subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        connectedSubnetResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of resources the InternalNetwork is disabled on. Can be either entire NetworkFabric or NetworkRack.
     */
    public val disabledOnResources: Output<List<String>>
        get() = javaResource.disabledOnResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARM resource ID of importRoutePolicy.
     */
    public val exportRoutePolicyId: Output<String>?
        get() = javaResource.exportRoutePolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM resource ID of importRoutePolicy.
     */
    public val importRoutePolicyId: Output<String>?
        get() = javaResource.importRoutePolicyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum transmission unit. Default value is 1500.
     */
    public val mtu: Output<Int>?
        get() = javaResource.mtu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Static Route Configuration properties.
     */
    public val staticRouteConfiguration: Output<StaticRouteConfigurationResponse>?
        get() = javaResource.staticRouteConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> staticRouteConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Vlan identifier. Example: 1001.
     */
    public val vlanId: Output<Int>
        get() = javaResource.vlanId().applyValue({ args0 -> args0 })
}

public object InternalNetworkMapper : ResourceMapper<InternalNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.InternalNetwork::class == javaResource::class

    override fun map(javaResource: Resource): InternalNetwork = InternalNetwork(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.InternalNetwork,
    )
}

/**
 * @see [InternalNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InternalNetwork].
 */
public suspend fun internalNetwork(
    name: String,
    block: suspend InternalNetworkResourceBuilder.() -> Unit,
): InternalNetwork {
    val builder = InternalNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InternalNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun internalNetwork(name: String): InternalNetwork {
    val builder = InternalNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
