@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.InternalNetworkArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.BgpConfigurationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.BgpConfigurationArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ConnectedSubnetArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ConnectedSubnetArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.StaticRouteConfigurationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.StaticRouteConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the InternalNetwork item.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### InternalNetworks_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var internalNetwork = new AzureNative.ManagedNetworkFabric.InternalNetwork("internalNetwork", new()
 *     {
 *         BgpConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.BgpConfigurationArgs
 *         {
 *             AllowAS = 1,
 *             AllowASOverride = AzureNative.ManagedNetworkFabric.AllowASOverride.Enable,
 *             DefaultRouteOriginate = AzureNative.ManagedNetworkFabric.BooleanEnumProperty.True,
 *             Ipv4ListenRangePrefixes = new[]
 *             {
 *                 "10.1.0.0/25",
 *             },
 *             Ipv4NeighborAddress = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.NeighborAddressArgs
 *                 {
 *                     Address = "10.1.0.0",
 *                 },
 *             },
 *             Ipv6ListenRangePrefixes = new[]
 *             {
 *                 "2fff::/66",
 *             },
 *             Ipv6NeighborAddress = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.NeighborAddressArgs
 *                 {
 *                     Address = "2fff::",
 *                 },
 *             },
 *             PeerASN = 6,
 *         },
 *         ConnectedIPv4Subnets = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.ConnectedSubnetArgs
 *             {
 *                 Prefix = "10.0.0.0/24",
 *             },
 *         },
 *         ConnectedIPv6Subnets = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.ConnectedSubnetArgs
 *             {
 *                 Prefix = "3FFE:FFFF:0:CD30::a0/29",
 *             },
 *         },
 *         ExportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2",
 *         ImportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1",
 *         InternalNetworkName = "example-internalnetwork",
 *         L3IsolationDomainName = "example-l3domain",
 *         Mtu = 1500,
 *         ResourceGroupName = "resourceGroupName",
 *         StaticRouteConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.StaticRouteConfigurationArgs
 *         {
 *             Ipv4Routes = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.StaticRoutePropertiesArgs
 *                 {
 *                     NextHop = new[]
 *                     {
 *                         "10.0.0.1",
 *                     },
 *                     Prefix = "10.1.0.0/24",
 *                 },
 *             },
 *             Ipv6Routes = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.StaticRoutePropertiesArgs
 *                 {
 *                     NextHop = new[]
 *                     {
 *                         "2ffe::1",
 *                     },
 *                     Prefix = "2fff::/64",
 *                 },
 *             },
 *         },
 *         VlanId = 501,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewInternalNetwork(ctx, "internalNetwork", &managednetworkfabric.InternalNetworkArgs{
 * 			BgpConfiguration: &managednetworkfabric.BgpConfigurationArgs{
 * 				AllowAS:               pulumi.Int(1),
 * 				AllowASOverride:       pulumi.String(managednetworkfabric.AllowASOverrideEnable),
 * 				DefaultRouteOriginate: pulumi.String(managednetworkfabric.BooleanEnumPropertyTrue),
 * 				Ipv4ListenRangePrefixes: pulumi.StringArray{
 * 					pulumi.String("10.1.0.0/25"),
 * 				},
 * 				Ipv4NeighborAddress: managednetworkfabric.NeighborAddressArray{
 * 					&managednetworkfabric.NeighborAddressArgs{
 * 						Address: pulumi.String("10.1.0.0"),
 * 					},
 * 				},
 * 				Ipv6ListenRangePrefixes: pulumi.StringArray{
 * 					pulumi.String("2fff::/66"),
 * 				},
 * 				Ipv6NeighborAddress: managednetworkfabric.NeighborAddressArray{
 * 					&managednetworkfabric.NeighborAddressArgs{
 * 						Address: pulumi.String("2fff::"),
 * 					},
 * 				},
 * 				PeerASN: pulumi.Int(6),
 * 			},
 * 			ConnectedIPv4Subnets: managednetworkfabric.ConnectedSubnetArray{
 * 				&managednetworkfabric.ConnectedSubnetArgs{
 * 					Prefix: pulumi.String("10.0.0.0/24"),
 * 				},
 * 			},
 * 			ConnectedIPv6Subnets: managednetworkfabric.ConnectedSubnetArray{
 * 				&managednetworkfabric.ConnectedSubnetArgs{
 * 					Prefix: pulumi.String("3FFE:FFFF:0:CD30::a0/29"),
 * 				},
 * 			},
 * 			ExportRoutePolicyId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2"),
 * 			ImportRoutePolicyId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1"),
 * 			InternalNetworkName:   pulumi.String("example-internalnetwork"),
 * 			L3IsolationDomainName: pulumi.String("example-l3domain"),
 * 			Mtu:                   pulumi.Int(1500),
 * 			ResourceGroupName:     pulumi.String("resourceGroupName"),
 * 			StaticRouteConfiguration: &managednetworkfabric.StaticRouteConfigurationArgs{
 * 				Ipv4Routes: managednetworkfabric.StaticRoutePropertiesArray{
 * 					&managednetworkfabric.StaticRoutePropertiesArgs{
 * 						NextHop: pulumi.StringArray{
 * 							pulumi.String("10.0.0.1"),
 * 						},
 * 						Prefix: pulumi.String("10.1.0.0/24"),
 * 					},
 * 				},
 * 				Ipv6Routes: managednetworkfabric.StaticRoutePropertiesArray{
 * 					&managednetworkfabric.StaticRoutePropertiesArgs{
 * 						NextHop: pulumi.StringArray{
 * 							pulumi.String("2ffe::1"),
 * 						},
 * 						Prefix: pulumi.String("2fff::/64"),
 * 					},
 * 				},
 * 			},
 * 			VlanId: pulumi.Int(501),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.InternalNetwork;
 * import com.pulumi.azurenative.managednetworkfabric.InternalNetworkArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.BgpConfigurationArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.ConnectedSubnetArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.StaticRouteConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var internalNetwork = new InternalNetwork("internalNetwork", InternalNetworkArgs.builder()
 *             .bgpConfiguration(BgpConfigurationArgs.builder()
 *                 .allowAS(1)
 *                 .allowASOverride("Enable")
 *                 .defaultRouteOriginate("True")
 *                 .ipv4ListenRangePrefixes("10.1.0.0/25")
 *                 .ipv4NeighborAddress(NeighborAddressArgs.builder()
 *                     .address("10.1.0.0")
 *                     .build())
 *                 .ipv6ListenRangePrefixes("2fff::/66")
 *                 .ipv6NeighborAddress(NeighborAddressArgs.builder()
 *                     .address("2fff::")
 *                     .build())
 *                 .peerASN(6)
 *                 .build())
 *             .connectedIPv4Subnets(ConnectedSubnetArgs.builder()
 *                 .prefix("10.0.0.0/24")
 *                 .build())
 *             .connectedIPv6Subnets(ConnectedSubnetArgs.builder()
 *                 .prefix("3FFE:FFFF:0:CD30::a0/29")
 *                 .build())
 *             .exportRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2")
 *             .importRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1")
 *             .internalNetworkName("example-internalnetwork")
 *             .l3IsolationDomainName("example-l3domain")
 *             .mtu(1500)
 *             .resourceGroupName("resourceGroupName")
 *             .staticRouteConfiguration(StaticRouteConfigurationArgs.builder()
 *                 .ipv4Routes(StaticRoutePropertiesArgs.builder()
 *                     .nextHop("10.0.0.1")
 *                     .prefix("10.1.0.0/24")
 *                     .build())
 *                 .ipv6Routes(StaticRoutePropertiesArgs.builder()
 *                     .nextHop("2ffe::1")
 *                     .prefix("2fff::/64")
 *                     .build())
 *                 .build())
 *             .vlanId(501)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:InternalNetwork example-externalnetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/{l3IsolationDomainName}/internalNetworks/{internalNetworkName}
 * ```
 * @property annotation Switch configuration description.
 * @property bgpConfiguration BGP configuration properties
 * @property connectedIPv4Subnets List with object connected IPv4 Subnets.
 * @property connectedIPv6Subnets List with object connected IPv6 Subnets.
 * @property exportRoutePolicyId ARM resource ID of importRoutePolicy.
 * @property importRoutePolicyId ARM resource ID of importRoutePolicy.
 * @property internalNetworkName Name of the InternalNetwork
 * @property l3IsolationDomainName Name of the L3IsolationDomain
 * @property mtu Maximum transmission unit. Default value is 1500.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property staticRouteConfiguration Static Route Configuration properties.
 * @property vlanId Vlan identifier. Example: 1001.
 */
public data class InternalNetworkArgs(
    public val `annotation`: Output<String>? = null,
    public val bgpConfiguration: Output<BgpConfigurationArgs>? = null,
    public val connectedIPv4Subnets: Output<List<ConnectedSubnetArgs>>? = null,
    public val connectedIPv6Subnets: Output<List<ConnectedSubnetArgs>>? = null,
    public val exportRoutePolicyId: Output<String>? = null,
    public val importRoutePolicyId: Output<String>? = null,
    public val internalNetworkName: Output<String>? = null,
    public val l3IsolationDomainName: Output<String>? = null,
    public val mtu: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val staticRouteConfiguration: Output<StaticRouteConfigurationArgs>? = null,
    public val vlanId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.InternalNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.InternalNetworkArgs =
        com.pulumi.azurenative.managednetworkfabric.InternalNetworkArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .bgpConfiguration(bgpConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectedIPv4Subnets(
                connectedIPv4Subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .connectedIPv6Subnets(
                connectedIPv6Subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .exportRoutePolicyId(exportRoutePolicyId?.applyValue({ args0 -> args0 }))
            .importRoutePolicyId(importRoutePolicyId?.applyValue({ args0 -> args0 }))
            .internalNetworkName(internalNetworkName?.applyValue({ args0 -> args0 }))
            .l3IsolationDomainName(l3IsolationDomainName?.applyValue({ args0 -> args0 }))
            .mtu(mtu?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .staticRouteConfiguration(
                staticRouteConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InternalNetworkArgs].
 */
@PulumiTagMarker
public class InternalNetworkArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var bgpConfiguration: Output<BgpConfigurationArgs>? = null

    private var connectedIPv4Subnets: Output<List<ConnectedSubnetArgs>>? = null

    private var connectedIPv6Subnets: Output<List<ConnectedSubnetArgs>>? = null

    private var exportRoutePolicyId: Output<String>? = null

    private var importRoutePolicyId: Output<String>? = null

    private var internalNetworkName: Output<String>? = null

    private var l3IsolationDomainName: Output<String>? = null

    private var mtu: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var staticRouteConfiguration: Output<StaticRouteConfigurationArgs>? = null

    private var vlanId: Output<Int>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("jmitupydqmbddigm")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value BGP configuration properties
     */
    @JvmName("gudbwtqgcqcynpaj")
    public suspend fun bgpConfiguration(`value`: Output<BgpConfigurationArgs>) {
        this.bgpConfiguration = value
    }

    /**
     * @param value List with object connected IPv4 Subnets.
     */
    @JvmName("mnidytyapthpvihu")
    public suspend fun connectedIPv4Subnets(`value`: Output<List<ConnectedSubnetArgs>>) {
        this.connectedIPv4Subnets = value
    }

    @JvmName("wewdasbajuuwanbx")
    public suspend fun connectedIPv4Subnets(vararg values: Output<ConnectedSubnetArgs>) {
        this.connectedIPv4Subnets = Output.all(values.asList())
    }

    /**
     * @param values List with object connected IPv4 Subnets.
     */
    @JvmName("hsyalsxorvnlbeel")
    public suspend fun connectedIPv4Subnets(values: List<Output<ConnectedSubnetArgs>>) {
        this.connectedIPv4Subnets = Output.all(values)
    }

    /**
     * @param value List with object connected IPv6 Subnets.
     */
    @JvmName("gfrlwbmdrdltyaqx")
    public suspend fun connectedIPv6Subnets(`value`: Output<List<ConnectedSubnetArgs>>) {
        this.connectedIPv6Subnets = value
    }

    @JvmName("ldecenbnivjhpgqs")
    public suspend fun connectedIPv6Subnets(vararg values: Output<ConnectedSubnetArgs>) {
        this.connectedIPv6Subnets = Output.all(values.asList())
    }

    /**
     * @param values List with object connected IPv6 Subnets.
     */
    @JvmName("wllljdfrfcabroxm")
    public suspend fun connectedIPv6Subnets(values: List<Output<ConnectedSubnetArgs>>) {
        this.connectedIPv6Subnets = Output.all(values)
    }

    /**
     * @param value ARM resource ID of importRoutePolicy.
     */
    @JvmName("axpotnfkibmofuhc")
    public suspend fun exportRoutePolicyId(`value`: Output<String>) {
        this.exportRoutePolicyId = value
    }

    /**
     * @param value ARM resource ID of importRoutePolicy.
     */
    @JvmName("nbodbpwudwsmwqtw")
    public suspend fun importRoutePolicyId(`value`: Output<String>) {
        this.importRoutePolicyId = value
    }

    /**
     * @param value Name of the InternalNetwork
     */
    @JvmName("ponayfmbaiskfvqx")
    public suspend fun internalNetworkName(`value`: Output<String>) {
        this.internalNetworkName = value
    }

    /**
     * @param value Name of the L3IsolationDomain
     */
    @JvmName("hhvoyhglinvljhlj")
    public suspend fun l3IsolationDomainName(`value`: Output<String>) {
        this.l3IsolationDomainName = value
    }

    /**
     * @param value Maximum transmission unit. Default value is 1500.
     */
    @JvmName("ayjjgeyexyjlnqtk")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pcmkusfqjigoejit")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Static Route Configuration properties.
     */
    @JvmName("arteoibutlfcvanv")
    public suspend fun staticRouteConfiguration(`value`: Output<StaticRouteConfigurationArgs>) {
        this.staticRouteConfiguration = value
    }

    /**
     * @param value Vlan identifier. Example: 1001.
     */
    @JvmName("kprpkdfdvwswwtbk")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("wncechiprionqbln")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value BGP configuration properties
     */
    @JvmName("wdxutddbeiyvxsnl")
    public suspend fun bgpConfiguration(`value`: BgpConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpConfiguration = mapped
    }

    /**
     * @param argument BGP configuration properties
     */
    @JvmName("ljbjsehpvobpbipd")
    public suspend fun bgpConfiguration(argument: suspend BgpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = BgpConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpConfiguration = mapped
    }

    /**
     * @param value List with object connected IPv4 Subnets.
     */
    @JvmName("vguwlfjgpgprhifo")
    public suspend fun connectedIPv4Subnets(`value`: List<ConnectedSubnetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedIPv4Subnets = mapped
    }

    /**
     * @param argument List with object connected IPv4 Subnets.
     */
    @JvmName("ilhhbeddpuiphbdn")
    public suspend
    fun connectedIPv4Subnets(argument: List<suspend ConnectedSubnetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectedSubnetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectedIPv4Subnets = mapped
    }

    /**
     * @param argument List with object connected IPv4 Subnets.
     */
    @JvmName("jysujbcnupxkjnrf")
    public suspend fun connectedIPv4Subnets(
        vararg
        argument: suspend ConnectedSubnetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectedSubnetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectedIPv4Subnets = mapped
    }

    /**
     * @param argument List with object connected IPv4 Subnets.
     */
    @JvmName("rofouejvyleeeppf")
    public suspend fun connectedIPv4Subnets(argument: suspend ConnectedSubnetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnectedSubnetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.connectedIPv4Subnets = mapped
    }

    /**
     * @param values List with object connected IPv4 Subnets.
     */
    @JvmName("ywhrtejwfdiuhcwd")
    public suspend fun connectedIPv4Subnets(vararg values: ConnectedSubnetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectedIPv4Subnets = mapped
    }

    /**
     * @param value List with object connected IPv6 Subnets.
     */
    @JvmName("odmlkcugiolhvgvn")
    public suspend fun connectedIPv6Subnets(`value`: List<ConnectedSubnetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedIPv6Subnets = mapped
    }

    /**
     * @param argument List with object connected IPv6 Subnets.
     */
    @JvmName("xobgpcenycxkunbj")
    public suspend
    fun connectedIPv6Subnets(argument: List<suspend ConnectedSubnetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectedSubnetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectedIPv6Subnets = mapped
    }

    /**
     * @param argument List with object connected IPv6 Subnets.
     */
    @JvmName("vfbcmtsfsgbprnqf")
    public suspend fun connectedIPv6Subnets(
        vararg
        argument: suspend ConnectedSubnetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectedSubnetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectedIPv6Subnets = mapped
    }

    /**
     * @param argument List with object connected IPv6 Subnets.
     */
    @JvmName("cgpskfietoafmoqb")
    public suspend fun connectedIPv6Subnets(argument: suspend ConnectedSubnetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnectedSubnetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.connectedIPv6Subnets = mapped
    }

    /**
     * @param values List with object connected IPv6 Subnets.
     */
    @JvmName("aqsceuoolffrouud")
    public suspend fun connectedIPv6Subnets(vararg values: ConnectedSubnetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectedIPv6Subnets = mapped
    }

    /**
     * @param value ARM resource ID of importRoutePolicy.
     */
    @JvmName("bjabidvvrcqvwxme")
    public suspend fun exportRoutePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportRoutePolicyId = mapped
    }

    /**
     * @param value ARM resource ID of importRoutePolicy.
     */
    @JvmName("icfkyrncxgsakple")
    public suspend fun importRoutePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importRoutePolicyId = mapped
    }

    /**
     * @param value Name of the InternalNetwork
     */
    @JvmName("guajongtdtqjxxqi")
    public suspend fun internalNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalNetworkName = mapped
    }

    /**
     * @param value Name of the L3IsolationDomain
     */
    @JvmName("trnhtytwnvirhnnh")
    public suspend fun l3IsolationDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l3IsolationDomainName = mapped
    }

    /**
     * @param value Maximum transmission unit. Default value is 1500.
     */
    @JvmName("rijlktkfelrfkmjv")
    public suspend fun mtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nrlfcpwslrhbrvxh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Static Route Configuration properties.
     */
    @JvmName("jlalioicfsfjlygx")
    public suspend fun staticRouteConfiguration(`value`: StaticRouteConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticRouteConfiguration = mapped
    }

    /**
     * @param argument Static Route Configuration properties.
     */
    @JvmName("pewjjbxrqoiwccom")
    public suspend
    fun staticRouteConfiguration(argument: suspend StaticRouteConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StaticRouteConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.staticRouteConfiguration = mapped
    }

    /**
     * @param value Vlan identifier. Example: 1001.
     */
    @JvmName("wljyjprmrlimljfj")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): InternalNetworkArgs = InternalNetworkArgs(
        `annotation` = `annotation`,
        bgpConfiguration = bgpConfiguration,
        connectedIPv4Subnets = connectedIPv4Subnets,
        connectedIPv6Subnets = connectedIPv6Subnets,
        exportRoutePolicyId = exportRoutePolicyId,
        importRoutePolicyId = importRoutePolicyId,
        internalNetworkName = internalNetworkName,
        l3IsolationDomainName = l3IsolationDomainName,
        mtu = mtu,
        resourceGroupName = resourceGroupName,
        staticRouteConfiguration = staticRouteConfiguration,
        vlanId = vlanId,
    )
}
