@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IpCommunity].
 */
@PulumiTagMarker
public class IpCommunityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpCommunityArgs = IpCommunityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpCommunityArgsBuilder.() -> Unit) {
        val builder = IpCommunityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IpCommunity {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.IpCommunity(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IpCommunity(builtJavaResource)
    }
}

/**
 * The IpCommunity resource definition.
 * Azure REST API version: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### IpCommunities_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipCommunity = new AzureNative.ManagedNetworkFabric.IpCommunity("ipCommunity", new()
 *     {
 *         Action = AzureNative.ManagedNetworkFabric.CommunityActionTypes.Permit,
 *         Annotation = "annotationValue",
 *         CommunityMembers = new[]
 *         {
 *             "1234:5678",
 *         },
 *         IpCommunityName = "example-ipCommunity",
 *         Location = "EastUS",
 *         ResourceGroupName = "rgIpCommunityLists",
 *         Tags =
 *         {
 *             { "key2814", "" },
 *         },
 *         WellKnownCommunities = new[]
 *         {
 *             AzureNative.ManagedNetworkFabric.WellKnownCommunities.Internet,
 *             AzureNative.ManagedNetworkFabric.WellKnownCommunities.LocalAS,
 *             AzureNative.ManagedNetworkFabric.WellKnownCommunities.NoExport,
 *             AzureNative.ManagedNetworkFabric.WellKnownCommunities.GShut,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewIpCommunity(ctx, "ipCommunity", &managednetworkfabric.IpCommunityArgs{
 * 			Action:     pulumi.String(managednetworkfabric.CommunityActionTypesPermit),
 * 			Annotation: pulumi.String("annotationValue"),
 * 			CommunityMembers: pulumi.StringArray{
 * 				pulumi.String("1234:5678"),
 * 			},
 * 			IpCommunityName:   pulumi.String("example-ipCommunity"),
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("rgIpCommunityLists"),
 * 			Tags: pulumi.StringMap{
 * 				"key2814": pulumi.String(""),
 * 			},
 * 			WellKnownCommunities: pulumi.StringArray{
 * 				pulumi.String(managednetworkfabric.WellKnownCommunitiesInternet),
 * 				pulumi.String(managednetworkfabric.WellKnownCommunitiesLocalAS),
 * 				pulumi.String(managednetworkfabric.WellKnownCommunitiesNoExport),
 * 				pulumi.String(managednetworkfabric.WellKnownCommunitiesGShut),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.IpCommunity;
 * import com.pulumi.azurenative.managednetworkfabric.IpCommunityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipCommunity = new IpCommunity("ipCommunity", IpCommunityArgs.builder()
 *             .action("Permit")
 *             .annotation("annotationValue")
 *             .communityMembers("1234:5678")
 *             .ipCommunityName("example-ipCommunity")
 *             .location("EastUS")
 *             .resourceGroupName("rgIpCommunityLists")
 *             .tags(Map.of("key2814", ""))
 *             .wellKnownCommunities(
 *                 "Internet",
 *                 "LocalAS",
 *                 "NoExport",
 *                 "GShut")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:IpCommunity example-ipCommunity /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipCommunities/{ipCommunityName}
 * ```
 */
public class IpCommunity internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.IpCommunity,
) : KotlinCustomResource(javaResource, IpCommunityMapper) {
    /**
     * Action to be taken on the configuration. Example: Permit | Deny.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List the communityMembers of IP Community .
     */
    public val communityMembers: Output<List<String>>
        get() = javaResource.communityMembers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Supported well known Community List.
     */
    public val wellKnownCommunities: Output<List<String>>?
        get() = javaResource.wellKnownCommunities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })
}

public object IpCommunityMapper : ResourceMapper<IpCommunity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.IpCommunity::class == javaResource::class

    override fun map(javaResource: Resource): IpCommunity = IpCommunity(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.IpCommunity,
    )
}

/**
 * @see [IpCommunity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpCommunity].
 */
public suspend fun ipCommunity(name: String, block: suspend IpCommunityResourceBuilder.() -> Unit):
    IpCommunity {
    val builder = IpCommunityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpCommunity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipCommunity(name: String): IpCommunity {
    val builder = IpCommunityResourceBuilder()
    builder.name(name)
    return builder.build()
}
