@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunityArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.CommunityActionTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The IpExtendedCommunity resource definition.
 * Azure REST API version: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### IpExtendedCommunities_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipExtendedCommunity = new AzureNative.ManagedNetworkFabric.IpExtendedCommunity("ipExtendedCommunity", new()
 *     {
 *         Action = AzureNative.ManagedNetworkFabric.CommunityActionTypes.Permit,
 *         Annotation = "annotationValue",
 *         IpExtendedCommunityName = "example_ipExtendedCommunity",
 *         Location = "EastUs",
 *         ResourceGroupName = "rgIpExtendedCommunityLists",
 *         RouteTargets = new[]
 *         {
 *             "1234:5678",
 *         },
 *         Tags =
 *         {
 *             { "key5054", "key" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewIpExtendedCommunity(ctx, "ipExtendedCommunity", &managednetworkfabric.IpExtendedCommunityArgs{
 * 			Action:                  pulumi.String(managednetworkfabric.CommunityActionTypesPermit),
 * 			Annotation:              pulumi.String("annotationValue"),
 * 			IpExtendedCommunityName: pulumi.String("example_ipExtendedCommunity"),
 * 			Location:                pulumi.String("EastUs"),
 * 			ResourceGroupName:       pulumi.String("rgIpExtendedCommunityLists"),
 * 			RouteTargets: pulumi.StringArray{
 * 				pulumi.String("1234:5678"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key5054": pulumi.String("key"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunity;
 * import com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipExtendedCommunity = new IpExtendedCommunity("ipExtendedCommunity", IpExtendedCommunityArgs.builder()
 *             .action("Permit")
 *             .annotation("annotationValue")
 *             .ipExtendedCommunityName("example_ipExtendedCommunity")
 *             .location("EastUs")
 *             .resourceGroupName("rgIpExtendedCommunityLists")
 *             .routeTargets("1234:5678")
 *             .tags(Map.of("key5054", "key"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:IpExtendedCommunity example_ipExtendedCommunity /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/{ipExtendedCommunityName}
 * ```
 * @property action Action to be taken on the configuration. Example: Permit | Deny.
 * @property annotation Switch configuration description.
 * @property ipExtendedCommunityName Name of the IP Extended Community
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property routeTargets Route Target List.The expected formats are ASN(plain):NN >> example 4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example 10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in range of 0-4294967295.
 * @property tags Resource tags.
 */
public data class IpExtendedCommunityArgs(
    public val action: Output<Either<String, CommunityActionTypes>>? = null,
    public val `annotation`: Output<String>? = null,
    public val ipExtendedCommunityName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeTargets: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunityArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunityArgs =
        com.pulumi.azurenative.managednetworkfabric.IpExtendedCommunityArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .ipExtendedCommunityName(ipExtendedCommunityName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeTargets(routeTargets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IpExtendedCommunityArgs].
 */
@PulumiTagMarker
public class IpExtendedCommunityArgsBuilder internal constructor() {
    private var action: Output<Either<String, CommunityActionTypes>>? = null

    private var `annotation`: Output<String>? = null

    private var ipExtendedCommunityName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeTargets: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("ittysbverkxwiyrg")
    public suspend fun action(`value`: Output<Either<String, CommunityActionTypes>>) {
        this.action = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("utldexbbrikldyhx")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Name of the IP Extended Community
     */
    @JvmName("ykwdcugeafuoifoj")
    public suspend fun ipExtendedCommunityName(`value`: Output<String>) {
        this.ipExtendedCommunityName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ekmiomppabntuida")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jvdsmflxdnditexq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Route Target List.The expected formats are ASN(plain):NN >> example 4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example 10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in range of 0-4294967295.
     */
    @JvmName("jgwmsisicuyrbotn")
    public suspend fun routeTargets(`value`: Output<List<String>>) {
        this.routeTargets = value
    }

    @JvmName("qbxlnkyvqxhmharg")
    public suspend fun routeTargets(vararg values: Output<String>) {
        this.routeTargets = Output.all(values.asList())
    }

    /**
     * @param values Route Target List.The expected formats are ASN(plain):NN >> example 4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example 10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in range of 0-4294967295.
     */
    @JvmName("mrogcgrkaqkbbdia")
    public suspend fun routeTargets(values: List<Output<String>>) {
        this.routeTargets = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oyqxnuqxxdfdgtco")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("cbotbqsmmcxhwtss")
    public suspend fun action(`value`: Either<String, CommunityActionTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("ltqimemkafglmask")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CommunityActionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("imbofdakmtorvejj")
    public fun action(`value`: CommunityActionTypes) {
        val toBeMapped = Either.ofRight<String, CommunityActionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("phvvwaxjmugxxhpn")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Name of the IP Extended Community
     */
    @JvmName("quiyysefppmonatq")
    public suspend fun ipExtendedCommunityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipExtendedCommunityName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dbqdxybqehpjajpn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bbniovturepfqora")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Route Target List.The expected formats are ASN(plain):NN >> example 4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example 10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in range of 0-4294967295.
     */
    @JvmName("cerqmlvsyvgtpckl")
    public suspend fun routeTargets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTargets = mapped
    }

    /**
     * @param values Route Target List.The expected formats are ASN(plain):NN >> example 4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example 10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in range of 0-4294967295.
     */
    @JvmName("hbepdbrwbxbhkdid")
    public suspend fun routeTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeTargets = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ttnicnhutfwetjkb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lfxnoclhtpomysdm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IpExtendedCommunityArgs = IpExtendedCommunityArgs(
        action = action,
        `annotation` = `annotation`,
        ipExtendedCommunityName = ipExtendedCommunityName,
        location = location,
        resourceGroupName = resourceGroupName,
        routeTargets = routeTargets,
        tags = tags,
    )
}
