@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.IpPrefixPropertiesResponseIpPrefixRules
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.IpPrefixPropertiesResponseIpPrefixRules.Companion.toKotlin as ipPrefixPropertiesResponseIpPrefixRulesToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IpPrefix].
 */
@PulumiTagMarker
public class IpPrefixResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpPrefixArgs = IpPrefixArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpPrefixArgsBuilder.() -> Unit) {
        val builder = IpPrefixArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IpPrefix {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.IpPrefix(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IpPrefix(builtJavaResource)
    }
}

/**
 * The IPPrefix resource definition.
 * Azure REST API version: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### IpPrefixes_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipPrefix = new AzureNative.ManagedNetworkFabric.IpPrefix("ipPrefix", new()
 *     {
 *         Annotation = "annotationValue",
 *         IpPrefixName = "example-ipPrefix",
 *         IpPrefixRules = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.IpPrefixPropertiesIpPrefixRulesArgs
 *             {
 *                 Action = AzureNative.ManagedNetworkFabric.CommunityActionTypes.Permit,
 *                 Condition = AzureNative.ManagedNetworkFabric.Condition.EqualTo,
 *                 NetworkPrefix = "1.1.1.0/24",
 *                 SequenceNumber = 12,
 *                 SubnetMaskLength = 28,
 *             },
 *         },
 *         Location = "EastUS",
 *         ResourceGroupName = "resourcegroupname",
 *         Tags =
 *         {
 *             { "key6404", "" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewIpPrefix(ctx, "ipPrefix", &managednetworkfabric.IpPrefixArgs{
 * 			Annotation:   pulumi.String("annotationValue"),
 * 			IpPrefixName: pulumi.String("example-ipPrefix"),
 * 			IpPrefixRules: managednetworkfabric.IpPrefixPropertiesIpPrefixRulesArray{
 * 				&managednetworkfabric.IpPrefixPropertiesIpPrefixRulesArgs{
 * 					Action:           pulumi.String(managednetworkfabric.CommunityActionTypesPermit),
 * 					Condition:        pulumi.String(managednetworkfabric.ConditionEqualTo),
 * 					NetworkPrefix:    pulumi.String("1.1.1.0/24"),
 * 					SequenceNumber:   pulumi.Float64(12),
 * 					SubnetMaskLength: pulumi.Int(28),
 * 				},
 * 			},
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 			Tags: pulumi.StringMap{
 * 				"key6404": pulumi.String(""),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.IpPrefix;
 * import com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.IpPrefixPropertiesIpPrefixRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipPrefix = new IpPrefix("ipPrefix", IpPrefixArgs.builder()
 *             .annotation("annotationValue")
 *             .ipPrefixName("example-ipPrefix")
 *             .ipPrefixRules(IpPrefixPropertiesIpPrefixRulesArgs.builder()
 *                 .action("Permit")
 *                 .condition("EqualTo")
 *                 .networkPrefix("1.1.1.0/24")
 *                 .sequenceNumber(12)
 *                 .subnetMaskLength(28)
 *                 .build())
 *             .location("EastUS")
 *             .resourceGroupName("resourcegroupname")
 *             .tags(Map.of("key6404", ""))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:IpPrefix example-ipPrefix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/{ipPrefixName}
 * ```
 */
public class IpPrefix internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.IpPrefix,
) : KotlinCustomResource(javaResource, IpPrefixMapper) {
    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * IpPrefix contains the list of IP PrefixRules objects.
     */
    public val ipPrefixRules: Output<List<IpPrefixPropertiesResponseIpPrefixRules>>
        get() = javaResource.ipPrefixRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ipPrefixPropertiesResponseIpPrefixRulesToKotlin(args0) })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IpPrefixMapper : ResourceMapper<IpPrefix> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.IpPrefix::class == javaResource::class

    override fun map(javaResource: Resource): IpPrefix = IpPrefix(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.IpPrefix,
    )
}

/**
 * @see [IpPrefix].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpPrefix].
 */
public suspend fun ipPrefix(name: String, block: suspend IpPrefixResourceBuilder.() -> Unit):
    IpPrefix {
    val builder = IpPrefixResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpPrefix].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipPrefix(name: String): IpPrefix {
    val builder = IpPrefixResourceBuilder()
    builder.name(name)
    return builder.build()
}
