@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.IpPrefixPropertiesIpPrefixRulesArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.IpPrefixPropertiesIpPrefixRulesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The IPPrefix resource definition.
 * Azure REST API version: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### IpPrefixes_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipPrefix = new AzureNative.ManagedNetworkFabric.IpPrefix("ipPrefix", new()
 *     {
 *         Annotation = "annotationValue",
 *         IpPrefixName = "example-ipPrefix",
 *         IpPrefixRules = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.IpPrefixPropertiesIpPrefixRulesArgs
 *             {
 *                 Action = AzureNative.ManagedNetworkFabric.CommunityActionTypes.Permit,
 *                 Condition = AzureNative.ManagedNetworkFabric.Condition.EqualTo,
 *                 NetworkPrefix = "1.1.1.0/24",
 *                 SequenceNumber = 12,
 *                 SubnetMaskLength = 28,
 *             },
 *         },
 *         Location = "EastUS",
 *         ResourceGroupName = "resourcegroupname",
 *         Tags =
 *         {
 *             { "key6404", "" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewIpPrefix(ctx, "ipPrefix", &managednetworkfabric.IpPrefixArgs{
 * 			Annotation:   pulumi.String("annotationValue"),
 * 			IpPrefixName: pulumi.String("example-ipPrefix"),
 * 			IpPrefixRules: managednetworkfabric.IpPrefixPropertiesIpPrefixRulesArray{
 * 				&managednetworkfabric.IpPrefixPropertiesIpPrefixRulesArgs{
 * 					Action:           pulumi.String(managednetworkfabric.CommunityActionTypesPermit),
 * 					Condition:        pulumi.String(managednetworkfabric.ConditionEqualTo),
 * 					NetworkPrefix:    pulumi.String("1.1.1.0/24"),
 * 					SequenceNumber:   pulumi.Float64(12),
 * 					SubnetMaskLength: pulumi.Int(28),
 * 				},
 * 			},
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 			Tags: pulumi.StringMap{
 * 				"key6404": pulumi.String(""),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.IpPrefix;
 * import com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.IpPrefixPropertiesIpPrefixRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipPrefix = new IpPrefix("ipPrefix", IpPrefixArgs.builder()
 *             .annotation("annotationValue")
 *             .ipPrefixName("example-ipPrefix")
 *             .ipPrefixRules(IpPrefixPropertiesIpPrefixRulesArgs.builder()
 *                 .action("Permit")
 *                 .condition("EqualTo")
 *                 .networkPrefix("1.1.1.0/24")
 *                 .sequenceNumber(12)
 *                 .subnetMaskLength(28)
 *                 .build())
 *             .location("EastUS")
 *             .resourceGroupName("resourcegroupname")
 *             .tags(Map.of("key6404", ""))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:IpPrefix example-ipPrefix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/{ipPrefixName}
 * ```
 * @property annotation Switch configuration description.
 * @property ipPrefixName Name of the IP Prefix
 * @property ipPrefixRules IpPrefix contains the list of IP PrefixRules objects.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class IpPrefixArgs(
    public val `annotation`: Output<String>? = null,
    public val ipPrefixName: Output<String>? = null,
    public val ipPrefixRules: Output<List<IpPrefixPropertiesIpPrefixRulesArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs =
        com.pulumi.azurenative.managednetworkfabric.IpPrefixArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .ipPrefixName(ipPrefixName?.applyValue({ args0 -> args0 }))
            .ipPrefixRules(
                ipPrefixRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IpPrefixArgs].
 */
@PulumiTagMarker
public class IpPrefixArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var ipPrefixName: Output<String>? = null

    private var ipPrefixRules: Output<List<IpPrefixPropertiesIpPrefixRulesArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("hbbrxinpqgthtsoo")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Name of the IP Prefix
     */
    @JvmName("ptmrkhxafygbqjbd")
    public suspend fun ipPrefixName(`value`: Output<String>) {
        this.ipPrefixName = value
    }

    /**
     * @param value IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("kcfgnplkqymlfobv")
    public suspend fun ipPrefixRules(`value`: Output<List<IpPrefixPropertiesIpPrefixRulesArgs>>) {
        this.ipPrefixRules = value
    }

    @JvmName("kjbxgfcdnsybemcy")
    public suspend fun ipPrefixRules(vararg values: Output<IpPrefixPropertiesIpPrefixRulesArgs>) {
        this.ipPrefixRules = Output.all(values.asList())
    }

    /**
     * @param values IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("vxnrbvvjcngwmstg")
    public suspend fun ipPrefixRules(values: List<Output<IpPrefixPropertiesIpPrefixRulesArgs>>) {
        this.ipPrefixRules = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uhgvuruankiatgug")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mqtjaourntaddrlm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nqkluvgwhoityteh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("gtarvunpibpyqqap")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Name of the IP Prefix
     */
    @JvmName("vbuvjrwgofsrvofo")
    public suspend fun ipPrefixName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPrefixName = mapped
    }

    /**
     * @param value IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("bvanpflkhydncbhw")
    public suspend fun ipPrefixRules(`value`: List<IpPrefixPropertiesIpPrefixRulesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPrefixRules = mapped
    }

    /**
     * @param argument IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("sqyearhoigqrvnwj")
    public suspend
    fun ipPrefixRules(argument: List<suspend IpPrefixPropertiesIpPrefixRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpPrefixPropertiesIpPrefixRulesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipPrefixRules = mapped
    }

    /**
     * @param argument IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("kulorpoortbrtfeb")
    public suspend fun ipPrefixRules(
        vararg
        argument: suspend IpPrefixPropertiesIpPrefixRulesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IpPrefixPropertiesIpPrefixRulesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipPrefixRules = mapped
    }

    /**
     * @param argument IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("iyhugahcdqstuonm")
    public suspend
    fun ipPrefixRules(argument: suspend IpPrefixPropertiesIpPrefixRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IpPrefixPropertiesIpPrefixRulesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipPrefixRules = mapped
    }

    /**
     * @param values IpPrefix contains the list of IP PrefixRules objects.
     */
    @JvmName("ivhfqlenyvlqsymk")
    public suspend fun ipPrefixRules(vararg values: IpPrefixPropertiesIpPrefixRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipPrefixRules = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eqqtlemanvvkphtd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eisqrelqkuhvmwdm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wskswaingxuteats")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("iloiyxfnxnviwqrt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IpPrefixArgs = IpPrefixArgs(
        `annotation` = `annotation`,
        ipPrefixName = ipPrefixName,
        ipPrefixRules = ipPrefixRules,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
