@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NetworkDevice].
 */
@PulumiTagMarker
public class NetworkDeviceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkDeviceArgs = NetworkDeviceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkDeviceArgsBuilder.() -> Unit) {
        val builder = NetworkDeviceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkDevice {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NetworkDevice(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkDevice(builtJavaResource)
    }
}

/**
 * The NetworkDevice resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkDevices_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkDevice = new AzureNative.ManagedNetworkFabric.NetworkDevice("networkDevice", new()
 *     {
 *         Annotation = "null",
 *         HostName = "networkDeviceName",
 *         Location = "eastus",
 *         NetworkDeviceName = "networkDeviceName",
 *         NetworkDeviceRole = AzureNative.ManagedNetworkFabric.NetworkDeviceRoleTypes.CE,
 *         NetworkDeviceSku = "DefaultSku",
 *         ResourceGroupName = "resourceGroupName",
 *         SerialNumber = "Arista;DCS-7280PR3-24;12.05;JPE21330382",
 *         Tags =
 *         {
 *             { "keyID", "keyValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkDevice(ctx, "networkDevice", &managednetworkfabric.NetworkDeviceArgs{
 * 			Annotation:        pulumi.String("null"),
 * 			HostName:          pulumi.String("networkDeviceName"),
 * 			Location:          pulumi.String("eastus"),
 * 			NetworkDeviceName: pulumi.String("networkDeviceName"),
 * 			NetworkDeviceRole: pulumi.String(managednetworkfabric.NetworkDeviceRoleTypesCE),
 * 			NetworkDeviceSku:  pulumi.String("DefaultSku"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SerialNumber:      pulumi.String("Arista;DCS-7280PR3-24;12.05;JPE21330382"),
 * 			Tags: pulumi.StringMap{
 * 				"keyID": pulumi.String("keyValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkDevice;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkDevice = new NetworkDevice("networkDevice", NetworkDeviceArgs.builder()
 *             .annotation("null")
 *             .hostName("networkDeviceName")
 *             .location("eastus")
 *             .networkDeviceName("networkDeviceName")
 *             .networkDeviceRole("CE")
 *             .networkDeviceSku("DefaultSku")
 *             .resourceGroupName("resourceGroupName")
 *             .serialNumber("Arista;DCS-7280PR3-24;12.05;JPE21330382")
 *             .tags(Map.of("keyID", "keyValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkDevice networkDeviceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkDevices/{networkDeviceName}
 * ```
 */
public class NetworkDevice internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NetworkDevice,
) : KotlinCustomResource(javaResource, NetworkDeviceMapper) {
    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The host Name of the device.
     */
    public val hostName: Output<String>?
        get() = javaResource.hostName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * networkDeviceRole is the device role: Example: CE | ToR.
     */
    public val networkDeviceRole: Output<String>
        get() = javaResource.networkDeviceRole().applyValue({ args0 -> args0 })

    /**
     * Network Device SKU name.
     */
    public val networkDeviceSku: Output<String>
        get() = javaResource.networkDeviceSku().applyValue({ args0 -> args0 })

    /**
     * Reference to network rack resource id.
     */
    public val networkRackId: Output<String>
        get() = javaResource.networkRackId().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber. Example: Arista;DCS-7280DR3-24;12.05;JPE21116969
     */
    public val serialNumber: Output<String>
        get() = javaResource.serialNumber().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Current version of the device as defined in SKU.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object NetworkDeviceMapper : ResourceMapper<NetworkDevice> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NetworkDevice::class == javaResource::class

    override fun map(javaResource: Resource): NetworkDevice = NetworkDevice(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.NetworkDevice,
    )
}

/**
 * @see [NetworkDevice].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkDevice].
 */
public suspend fun networkDevice(
    name: String,
    block: suspend NetworkDeviceResourceBuilder.() -> Unit,
): NetworkDevice {
    val builder = NetworkDeviceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkDevice].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkDevice(name: String): NetworkDevice {
    val builder = NetworkDeviceResourceBuilder()
    builder.name(name)
    return builder.build()
}
