@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NetworkInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the NetworkInterface resource.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkInterfaces_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterface = new AzureNative.ManagedNetworkFabric.NetworkInterface("networkInterface", new()
 *     {
 *         Annotation = "null",
 *         NetworkDeviceName = "networkDeviceName",
 *         NetworkInterfaceName = "networkInterfaceName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkInterface(ctx, "networkInterface", &managednetworkfabric.NetworkInterfaceArgs{
 * 			Annotation:           pulumi.String("null"),
 * 			NetworkDeviceName:    pulumi.String("networkDeviceName"),
 * 			NetworkInterfaceName: pulumi.String("networkInterfaceName"),
 * 			ResourceGroupName:    pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkInterface;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterface = new NetworkInterface("networkInterface", NetworkInterfaceArgs.builder()
 *             .annotation("null")
 *             .networkDeviceName("networkDeviceName")
 *             .networkInterfaceName("networkInterfaceName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkInterface networkInterfaceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkDevices/{networkDeviceName}/networkInterfaces/{networkInterfaceName}
 * ```
 * @property annotation Switch configuration description.
 * @property networkDeviceName Name of the NetworkDevice
 * @property networkInterfaceName Name of the NetworkInterface
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class NetworkInterfaceArgs(
    public val `annotation`: Output<String>? = null,
    public val networkDeviceName: Output<String>? = null,
    public val networkInterfaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.NetworkInterfaceArgs =
        com.pulumi.azurenative.managednetworkfabric.NetworkInterfaceArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .networkDeviceName(networkDeviceName?.applyValue({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var networkDeviceName: Output<String>? = null

    private var networkInterfaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("bsxxqtpqrfjbslvg")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Name of the NetworkDevice
     */
    @JvmName("qqcpmlebuodsaolm")
    public suspend fun networkDeviceName(`value`: Output<String>) {
        this.networkDeviceName = value
    }

    /**
     * @param value Name of the NetworkInterface
     */
    @JvmName("cslvufbxwmbbtaii")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pfilcsihoeaydwrn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("fcqgsvtnwsvaabyt")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Name of the NetworkDevice
     */
    @JvmName("fbdrknondhqgicom")
    public suspend fun networkDeviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDeviceName = mapped
    }

    /**
     * @param value Name of the NetworkInterface
     */
    @JvmName("oaosnrsphmpgtuvu")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xnfubtwqbdomxumk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): NetworkInterfaceArgs = NetworkInterfaceArgs(
        `annotation` = `annotation`,
        networkDeviceName = networkDeviceName,
        networkInterfaceName = networkInterfaceName,
        resourceGroupName = resourceGroupName,
    )
}
