@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnectArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.BooleanEnumProperty
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.NniType
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.Layer2ConfigurationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.Layer2ConfigurationArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.Layer3ConfigurationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.Layer3ConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The NetworkToNetworkInterconnect resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkToNetworkInterconnects_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkToNetworkInterconnect = new AzureNative.ManagedNetworkFabric.NetworkToNetworkInterconnect("networkToNetworkInterconnect", new()
 *     {
 *         IsManagementType = AzureNative.ManagedNetworkFabric.BooleanEnumProperty.True,
 *         Layer2Configuration = new AzureNative.ManagedNetworkFabric.Inputs.Layer2ConfigurationArgs
 *         {
 *             Mtu = 1500,
 *             PortCount = 10,
 *         },
 *         Layer3Configuration = new AzureNative.ManagedNetworkFabric.Inputs.Layer3ConfigurationArgs
 *         {
 *             ExportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2",
 *             ImportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1",
 *             PeerASN = 50272,
 *             PrimaryIpv4Prefix = "172.31.0.0/31",
 *             PrimaryIpv6Prefix = "3FFE:FFFF:0:CD30::a0/126",
 *             SecondaryIpv4Prefix = "172.31.0.20/31",
 *             SecondaryIpv6Prefix = "3FFE:FFFF:0:CD30::a4/126",
 *             VlanId = 2064,
 *         },
 *         NetworkFabricName = "FabricName",
 *         NetworkToNetworkInterconnectName = "DefaultNNI",
 *         NniType = AzureNative.ManagedNetworkFabric.NniType.CE,
 *         ResourceGroupName = "resourceGroupName",
 *         UseOptionB = AzureNative.ManagedNetworkFabric.BooleanEnumProperty.False,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkToNetworkInterconnect(ctx, "networkToNetworkInterconnect", &managednetworkfabric.NetworkToNetworkInterconnectArgs{
 * 			IsManagementType: pulumi.String(managednetworkfabric.BooleanEnumPropertyTrue),
 * 			Layer2Configuration: &managednetworkfabric.Layer2ConfigurationArgs{
 * 				Mtu:       pulumi.Int(1500),
 * 				PortCount: pulumi.Int(10),
 * 			},
 * 			Layer3Configuration: &managednetworkfabric.Layer3ConfigurationArgs{
 * 				ExportRoutePolicyId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2"),
 * 				ImportRoutePolicyId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1"),
 * 				PeerASN:             pulumi.Int(50272),
 * 				PrimaryIpv4Prefix:   pulumi.String("172.31.0.0/31"),
 * 				PrimaryIpv6Prefix:   pulumi.String("3FFE:FFFF:0:CD30::a0/126"),
 * 				SecondaryIpv4Prefix: pulumi.String("172.31.0.20/31"),
 * 				SecondaryIpv6Prefix: pulumi.String("3FFE:FFFF:0:CD30::a4/126"),
 * 				VlanId:              pulumi.Int(2064),
 * 			},
 * 			NetworkFabricName:                pulumi.String("FabricName"),
 * 			NetworkToNetworkInterconnectName: pulumi.String("DefaultNNI"),
 * 			NniType:                          pulumi.String(managednetworkfabric.NniTypeCE),
 * 			ResourceGroupName:                pulumi.String("resourceGroupName"),
 * 			UseOptionB:                       pulumi.String(managednetworkfabric.BooleanEnumPropertyFalse),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnect;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnectArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.Layer2ConfigurationArgs;
 * import com.pulumi.azurenative.managednetworkfabric.inputs.Layer3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkToNetworkInterconnect = new NetworkToNetworkInterconnect("networkToNetworkInterconnect", NetworkToNetworkInterconnectArgs.builder()
 *             .isManagementType("True")
 *             .layer2Configuration(Layer2ConfigurationArgs.builder()
 *                 .mtu(1500)
 *                 .portCount(10)
 *                 .build())
 *             .layer3Configuration(Layer3ConfigurationArgs.builder()
 *                 .exportRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2")
 *                 .importRoutePolicyId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1")
 *                 .peerASN(50272)
 *                 .primaryIpv4Prefix("172.31.0.0/31")
 *                 .primaryIpv6Prefix("3FFE:FFFF:0:CD30::a0/126")
 *                 .secondaryIpv4Prefix("172.31.0.20/31")
 *                 .secondaryIpv6Prefix("3FFE:FFFF:0:CD30::a4/126")
 *                 .vlanId(2064)
 *                 .build())
 *             .networkFabricName("FabricName")
 *             .networkToNetworkInterconnectName("DefaultNNI")
 *             .nniType("CE")
 *             .resourceGroupName("resourceGroupName")
 *             .useOptionB("False")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkToNetworkInterconnect DefaultNNI /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabrics/{networkFabricName}/networkToNetworkInterconnects/{networkToNetworkInterconnectName}
 * ```
 * @property isManagementType Configuration to use NNI for Infrastructure Management. Example: True/False.
 * @property layer2Configuration Common properties for Layer2Configuration.
 * @property layer3Configuration Common properties for Layer3Configuration.
 * @property networkFabricName Name of the NetworkFabric.
 * @property networkToNetworkInterconnectName Name of the NetworkToNetworkInterconnectName
 * @property nniType Type of NNI used. Example: CE | NPB
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property useOptionB Based on this parameter the layer2/layer3 is made as mandatory. Example: True/False
 */
public data class NetworkToNetworkInterconnectArgs(
    public val isManagementType: Output<Either<String, BooleanEnumProperty>>? = null,
    public val layer2Configuration: Output<Layer2ConfigurationArgs>? = null,
    public val layer3Configuration: Output<Layer3ConfigurationArgs>? = null,
    public val networkFabricName: Output<String>? = null,
    public val networkToNetworkInterconnectName: Output<String>? = null,
    public val nniType: Output<Either<String, NniType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val useOptionB: Output<Either<String, BooleanEnumProperty>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnectArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnectArgs =
        com.pulumi.azurenative.managednetworkfabric.NetworkToNetworkInterconnectArgs.builder()
            .isManagementType(
                isManagementType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .layer2Configuration(
                layer2Configuration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .layer3Configuration(
                layer3Configuration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkFabricName(networkFabricName?.applyValue({ args0 -> args0 }))
            .networkToNetworkInterconnectName(networkToNetworkInterconnectName?.applyValue({ args0 -> args0 }))
            .nniType(
                nniType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .useOptionB(
                useOptionB?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkToNetworkInterconnectArgs].
 */
@PulumiTagMarker
public class NetworkToNetworkInterconnectArgsBuilder internal constructor() {
    private var isManagementType: Output<Either<String, BooleanEnumProperty>>? = null

    private var layer2Configuration: Output<Layer2ConfigurationArgs>? = null

    private var layer3Configuration: Output<Layer3ConfigurationArgs>? = null

    private var networkFabricName: Output<String>? = null

    private var networkToNetworkInterconnectName: Output<String>? = null

    private var nniType: Output<Either<String, NniType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var useOptionB: Output<Either<String, BooleanEnumProperty>>? = null

    /**
     * @param value Configuration to use NNI for Infrastructure Management. Example: True/False.
     */
    @JvmName("ysrdohkwbmtitmhy")
    public suspend fun isManagementType(`value`: Output<Either<String, BooleanEnumProperty>>) {
        this.isManagementType = value
    }

    /**
     * @param value Common properties for Layer2Configuration.
     */
    @JvmName("iocrtmywveerrwfc")
    public suspend fun layer2Configuration(`value`: Output<Layer2ConfigurationArgs>) {
        this.layer2Configuration = value
    }

    /**
     * @param value Common properties for Layer3Configuration.
     */
    @JvmName("hdwaphkooonifqtn")
    public suspend fun layer3Configuration(`value`: Output<Layer3ConfigurationArgs>) {
        this.layer3Configuration = value
    }

    /**
     * @param value Name of the NetworkFabric.
     */
    @JvmName("bnkjfnotbxkbosfk")
    public suspend fun networkFabricName(`value`: Output<String>) {
        this.networkFabricName = value
    }

    /**
     * @param value Name of the NetworkToNetworkInterconnectName
     */
    @JvmName("cwkjmbvcvirydckr")
    public suspend fun networkToNetworkInterconnectName(`value`: Output<String>) {
        this.networkToNetworkInterconnectName = value
    }

    /**
     * @param value Type of NNI used. Example: CE | NPB
     */
    @JvmName("minjwcmrdhobcouy")
    public suspend fun nniType(`value`: Output<Either<String, NniType>>) {
        this.nniType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wjtpwckunnnywvaf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Based on this parameter the layer2/layer3 is made as mandatory. Example: True/False
     */
    @JvmName("hndedtikmwyxeuuv")
    public suspend fun useOptionB(`value`: Output<Either<String, BooleanEnumProperty>>) {
        this.useOptionB = value
    }

    /**
     * @param value Configuration to use NNI for Infrastructure Management. Example: True/False.
     */
    @JvmName("xyxxsojpbksfpkbg")
    public suspend fun isManagementType(`value`: Either<String, BooleanEnumProperty>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isManagementType = mapped
    }

    /**
     * @param value Configuration to use NNI for Infrastructure Management. Example: True/False.
     */
    @JvmName("nseekpyjifdifmxp")
    public fun isManagementType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnumProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isManagementType = mapped
    }

    /**
     * @param value Configuration to use NNI for Infrastructure Management. Example: True/False.
     */
    @JvmName("aqosennjgysgpphb")
    public fun isManagementType(`value`: BooleanEnumProperty) {
        val toBeMapped = Either.ofRight<String, BooleanEnumProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isManagementType = mapped
    }

    /**
     * @param value Common properties for Layer2Configuration.
     */
    @JvmName("sbiiygkjmvpiqeit")
    public suspend fun layer2Configuration(`value`: Layer2ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layer2Configuration = mapped
    }

    /**
     * @param argument Common properties for Layer2Configuration.
     */
    @JvmName("novfooweprjmhggb")
    public suspend
    fun layer2Configuration(argument: suspend Layer2ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = Layer2ConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.layer2Configuration = mapped
    }

    /**
     * @param value Common properties for Layer3Configuration.
     */
    @JvmName("wulqvtsitjcyqijl")
    public suspend fun layer3Configuration(`value`: Layer3ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layer3Configuration = mapped
    }

    /**
     * @param argument Common properties for Layer3Configuration.
     */
    @JvmName("wxtcppnpxaxojiyq")
    public suspend
    fun layer3Configuration(argument: suspend Layer3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = Layer3ConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.layer3Configuration = mapped
    }

    /**
     * @param value Name of the NetworkFabric.
     */
    @JvmName("ejlykblhgnsiipbp")
    public suspend fun networkFabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricName = mapped
    }

    /**
     * @param value Name of the NetworkToNetworkInterconnectName
     */
    @JvmName("norovivcaubsssrh")
    public suspend fun networkToNetworkInterconnectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkToNetworkInterconnectName = mapped
    }

    /**
     * @param value Type of NNI used. Example: CE | NPB
     */
    @JvmName("chxmhyyydvqdeefs")
    public suspend fun nniType(`value`: Either<String, NniType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nniType = mapped
    }

    /**
     * @param value Type of NNI used. Example: CE | NPB
     */
    @JvmName("eenqraxqaawiuqdq")
    public fun nniType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NniType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nniType = mapped
    }

    /**
     * @param value Type of NNI used. Example: CE | NPB
     */
    @JvmName("mjgcdaclcwpdvofi")
    public fun nniType(`value`: NniType) {
        val toBeMapped = Either.ofRight<String, NniType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nniType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bjarqaowqbrnpfnb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Based on this parameter the layer2/layer3 is made as mandatory. Example: True/False
     */
    @JvmName("xrvrxslqtlnsbyjp")
    public suspend fun useOptionB(`value`: Either<String, BooleanEnumProperty>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useOptionB = mapped
    }

    /**
     * @param value Based on this parameter the layer2/layer3 is made as mandatory. Example: True/False
     */
    @JvmName("fweajkbslfcxdsec")
    public fun useOptionB(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnumProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useOptionB = mapped
    }

    /**
     * @param value Based on this parameter the layer2/layer3 is made as mandatory. Example: True/False
     */
    @JvmName("rjfgkccfvgftdokl")
    public fun useOptionB(`value`: BooleanEnumProperty) {
        val toBeMapped = Either.ofRight<String, BooleanEnumProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useOptionB = mapped
    }

    internal fun build(): NetworkToNetworkInterconnectArgs = NetworkToNetworkInterconnectArgs(
        isManagementType = isManagementType,
        layer2Configuration = layer2Configuration,
        layer3Configuration = layer3Configuration,
        networkFabricName = networkFabricName,
        networkToNetworkInterconnectName = networkToNetworkInterconnectName,
        nniType = nniType,
        resourceGroupName = resourceGroupName,
        useOptionB = useOptionB,
    )
}
