@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Dynamic match configuration object.
 * @property ipGroups List of IP Groups.
 * @property portGroups List of the port groups.
 * @property vlanGroups List of vlan groups.
 */
public data class CommonDynamicMatchConfigurationArgs(
    public val ipGroups: Output<List<IpGroupPropertiesArgs>>? = null,
    public val portGroups: Output<List<PortGroupPropertiesArgs>>? = null,
    public val vlanGroups: Output<List<VlanGroupPropertiesArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.CommonDynamicMatchConfigurationArgs.builder()
            .ipGroups(
                ipGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .portGroups(
                portGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vlanGroups(
                vlanGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CommonDynamicMatchConfigurationArgs].
 */
@PulumiTagMarker
public class CommonDynamicMatchConfigurationArgsBuilder internal constructor() {
    private var ipGroups: Output<List<IpGroupPropertiesArgs>>? = null

    private var portGroups: Output<List<PortGroupPropertiesArgs>>? = null

    private var vlanGroups: Output<List<VlanGroupPropertiesArgs>>? = null

    /**
     * @param value List of IP Groups.
     */
    @JvmName("issvnirprfrwdjmo")
    public suspend fun ipGroups(`value`: Output<List<IpGroupPropertiesArgs>>) {
        this.ipGroups = value
    }

    @JvmName("ismahjwbaejsvtiq")
    public suspend fun ipGroups(vararg values: Output<IpGroupPropertiesArgs>) {
        this.ipGroups = Output.all(values.asList())
    }

    /**
     * @param values List of IP Groups.
     */
    @JvmName("sfcufcvlbpfleiei")
    public suspend fun ipGroups(values: List<Output<IpGroupPropertiesArgs>>) {
        this.ipGroups = Output.all(values)
    }

    /**
     * @param value List of the port groups.
     */
    @JvmName("esjnbmtyreykqgmd")
    public suspend fun portGroups(`value`: Output<List<PortGroupPropertiesArgs>>) {
        this.portGroups = value
    }

    @JvmName("qevcsjcpntrexmji")
    public suspend fun portGroups(vararg values: Output<PortGroupPropertiesArgs>) {
        this.portGroups = Output.all(values.asList())
    }

    /**
     * @param values List of the port groups.
     */
    @JvmName("sybuvtmounbcfitm")
    public suspend fun portGroups(values: List<Output<PortGroupPropertiesArgs>>) {
        this.portGroups = Output.all(values)
    }

    /**
     * @param value List of vlan groups.
     */
    @JvmName("lduqlhetofmcylpp")
    public suspend fun vlanGroups(`value`: Output<List<VlanGroupPropertiesArgs>>) {
        this.vlanGroups = value
    }

    @JvmName("dueoetjwxnjhatac")
    public suspend fun vlanGroups(vararg values: Output<VlanGroupPropertiesArgs>) {
        this.vlanGroups = Output.all(values.asList())
    }

    /**
     * @param values List of vlan groups.
     */
    @JvmName("wjyajvoopppqjowj")
    public suspend fun vlanGroups(values: List<Output<VlanGroupPropertiesArgs>>) {
        this.vlanGroups = Output.all(values)
    }

    /**
     * @param value List of IP Groups.
     */
    @JvmName("kefjdaprgwxslncv")
    public suspend fun ipGroups(`value`: List<IpGroupPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipGroups = mapped
    }

    /**
     * @param argument List of IP Groups.
     */
    @JvmName("ewvasismhoxwgmev")
    public suspend fun ipGroups(argument: List<suspend IpGroupPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipGroups = mapped
    }

    /**
     * @param argument List of IP Groups.
     */
    @JvmName("gaakukrhqdwphbyr")
    public suspend fun ipGroups(vararg argument: suspend IpGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipGroups = mapped
    }

    /**
     * @param argument List of IP Groups.
     */
    @JvmName("itwrfwjrrxewdpxs")
    public suspend fun ipGroups(argument: suspend IpGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpGroupPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipGroups = mapped
    }

    /**
     * @param values List of IP Groups.
     */
    @JvmName("tcfqnctkiurupein")
    public suspend fun ipGroups(vararg values: IpGroupPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipGroups = mapped
    }

    /**
     * @param value List of the port groups.
     */
    @JvmName("bescybjabnqcrshj")
    public suspend fun portGroups(`value`: List<PortGroupPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portGroups = mapped
    }

    /**
     * @param argument List of the port groups.
     */
    @JvmName("yxqnrfajdeopolwy")
    public suspend fun portGroups(argument: List<suspend PortGroupPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PortGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portGroups = mapped
    }

    /**
     * @param argument List of the port groups.
     */
    @JvmName("wahfotronbljjmjk")
    public suspend fun portGroups(
        vararg
        argument: suspend PortGroupPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PortGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portGroups = mapped
    }

    /**
     * @param argument List of the port groups.
     */
    @JvmName("qbppatvmyuioyciu")
    public suspend fun portGroups(argument: suspend PortGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PortGroupPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.portGroups = mapped
    }

    /**
     * @param values List of the port groups.
     */
    @JvmName("iiukdpbpgvasxdvk")
    public suspend fun portGroups(vararg values: PortGroupPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portGroups = mapped
    }

    /**
     * @param value List of vlan groups.
     */
    @JvmName("scfncuwnyofhbfyg")
    public suspend fun vlanGroups(`value`: List<VlanGroupPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanGroups = mapped
    }

    /**
     * @param argument List of vlan groups.
     */
    @JvmName("gpreaiawbnxsvimy")
    public suspend fun vlanGroups(argument: List<suspend VlanGroupPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VlanGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vlanGroups = mapped
    }

    /**
     * @param argument List of vlan groups.
     */
    @JvmName("rqhjcdrujbiooltw")
    public suspend fun vlanGroups(
        vararg
        argument: suspend VlanGroupPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VlanGroupPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vlanGroups = mapped
    }

    /**
     * @param argument List of vlan groups.
     */
    @JvmName("lvteettdrmkbpvup")
    public suspend fun vlanGroups(argument: suspend VlanGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VlanGroupPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vlanGroups = mapped
    }

    /**
     * @param values List of vlan groups.
     */
    @JvmName("mkgfsedfmjkiadar")
    public suspend fun vlanGroups(vararg values: VlanGroupPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vlanGroups = mapped
    }

    internal fun build(): CommonDynamicMatchConfigurationArgs = CommonDynamicMatchConfigurationArgs(
        ipGroups = ipGroups,
        portGroups = portGroups,
        vlanGroups = vlanGroups,
    )
}
