@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.ExpressRouteConnectionInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ExpressRoute circuit ID and the Auth Key are required for you to successfully deploy NFC service.
 * @property expressRouteAuthorizationKey Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
 * @property expressRouteCircuitId The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory attribute.
 */
public data class ExpressRouteConnectionInformationArgs(
    public val expressRouteAuthorizationKey: Output<String>,
    public val expressRouteCircuitId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.ExpressRouteConnectionInformationArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.ExpressRouteConnectionInformationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.ExpressRouteConnectionInformationArgs.builder()
            .expressRouteAuthorizationKey(expressRouteAuthorizationKey.applyValue({ args0 -> args0 }))
            .expressRouteCircuitId(expressRouteCircuitId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteConnectionInformationArgs].
 */
@PulumiTagMarker
public class ExpressRouteConnectionInformationArgsBuilder internal constructor() {
    private var expressRouteAuthorizationKey: Output<String>? = null

    private var expressRouteCircuitId: Output<String>? = null

    /**
     * @param value Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
     */
    @JvmName("ylicvqocgmjajhpo")
    public suspend fun expressRouteAuthorizationKey(`value`: Output<String>) {
        this.expressRouteAuthorizationKey = value
    }

    /**
     * @param value The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory attribute.
     */
    @JvmName("eeoolxxukohdrdfx")
    public suspend fun expressRouteCircuitId(`value`: Output<String>) {
        this.expressRouteCircuitId = value
    }

    /**
     * @param value Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
     */
    @JvmName("aoavvrcmwpdlyxaq")
    public suspend fun expressRouteAuthorizationKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressRouteAuthorizationKey = mapped
    }

    /**
     * @param value The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory attribute.
     */
    @JvmName("ykykjpcntaggdfpi")
    public suspend fun expressRouteCircuitId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressRouteCircuitId = mapped
    }

    internal fun build(): ExpressRouteConnectionInformationArgs =
        ExpressRouteConnectionInformationArgs(
            expressRouteAuthorizationKey = expressRouteAuthorizationKey ?: throw
                PulumiNullFieldException("expressRouteAuthorizationKey"),
            expressRouteCircuitId = expressRouteCircuitId ?: throw
                PulumiNullFieldException("expressRouteCircuitId"),
        )
}
