@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetInternetGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property internetGatewayName Name of the Internet Gateway.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetInternetGatewayPlainArgs(
    public val internetGatewayName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetInternetGatewayPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetInternetGatewayPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetInternetGatewayPlainArgs.builder()
            .internetGatewayName(internetGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInternetGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetInternetGatewayPlainArgsBuilder internal constructor() {
    private var internetGatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Internet Gateway.
     */
    @JvmName("euvbpugisrpoyokv")
    public suspend fun internetGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.internetGatewayName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lqyatpxnveppogyl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInternetGatewayPlainArgs = GetInternetGatewayPlainArgs(
        internetGatewayName = internetGatewayName ?: throw PulumiNullFieldException("internetGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
