@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.IsolationDomainPropertiesArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.Encapsulation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Isolation Domain Properties.
 * @property encapsulation Type of encapsulation.
 * @property neighborGroupIds List of Neighbor Group IDs.
 */
public data class IsolationDomainPropertiesArgs(
    public val encapsulation: Output<Either<String, Encapsulation>>? = null,
    public val neighborGroupIds: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.IsolationDomainPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.IsolationDomainPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.IsolationDomainPropertiesArgs.builder()
            .encapsulation(
                encapsulation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .neighborGroupIds(neighborGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [IsolationDomainPropertiesArgs].
 */
@PulumiTagMarker
public class IsolationDomainPropertiesArgsBuilder internal constructor() {
    private var encapsulation: Output<Either<String, Encapsulation>>? = null

    private var neighborGroupIds: Output<List<String>>? = null

    /**
     * @param value Type of encapsulation.
     */
    @JvmName("ayrlfhhqctviwidx")
    public suspend fun encapsulation(`value`: Output<Either<String, Encapsulation>>) {
        this.encapsulation = value
    }

    /**
     * @param value List of Neighbor Group IDs.
     */
    @JvmName("tmoiwmvmurddhsil")
    public suspend fun neighborGroupIds(`value`: Output<List<String>>) {
        this.neighborGroupIds = value
    }

    @JvmName("mnbsgaehbervaywi")
    public suspend fun neighborGroupIds(vararg values: Output<String>) {
        this.neighborGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of Neighbor Group IDs.
     */
    @JvmName("itnjlxarokoebmch")
    public suspend fun neighborGroupIds(values: List<Output<String>>) {
        this.neighborGroupIds = Output.all(values)
    }

    /**
     * @param value Type of encapsulation.
     */
    @JvmName("suqsbjpwwvwwxkvq")
    public suspend fun encapsulation(`value`: Either<String, Encapsulation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encapsulation = mapped
    }

    /**
     * @param value Type of encapsulation.
     */
    @JvmName("xsbedftactpbmerf")
    public fun encapsulation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Encapsulation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encapsulation = mapped
    }

    /**
     * @param value Type of encapsulation.
     */
    @JvmName("ybpgnfpisfeqebvk")
    public fun encapsulation(`value`: Encapsulation) {
        val toBeMapped = Either.ofRight<String, Encapsulation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encapsulation = mapped
    }

    /**
     * @param value List of Neighbor Group IDs.
     */
    @JvmName("pvreeltaebjeedjo")
    public suspend fun neighborGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neighborGroupIds = mapped
    }

    /**
     * @param values List of Neighbor Group IDs.
     */
    @JvmName("fpflgtolqkwmjdod")
    public suspend fun neighborGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.neighborGroupIds = mapped
    }

    internal fun build(): IsolationDomainPropertiesArgs = IsolationDomainPropertiesArgs(
        encapsulation = encapsulation,
        neighborGroupIds = neighborGroupIds,
    )
}
