@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.NeighborAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Neighbor Address properties.
 * @property address IP Address.
 */
public data class NeighborAddressArgs(
    public val address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.NeighborAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.NeighborAddressArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.NeighborAddressArgs.builder()
            .address(address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NeighborAddressArgs].
 */
@PulumiTagMarker
public class NeighborAddressArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    /**
     * @param value IP Address.
     */
    @JvmName("auhyrncvehwxjtdn")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value IP Address.
     */
    @JvmName("plfmibjyrksdwmlt")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    internal fun build(): NeighborAddressArgs = NeighborAddressArgs(
        address = address,
    )
}
