@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.RulePropertiesArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.Action
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rules for the InternetGateways
 * @property action Specify action.
 * @property addressList List of Addresses to be allowed or denied.
 */
public data class RulePropertiesArgs(
    public val action: Output<Either<String, Action>>,
    public val addressList: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.RulePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.RulePropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.RulePropertiesArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .addressList(addressList.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RulePropertiesArgs].
 */
@PulumiTagMarker
public class RulePropertiesArgsBuilder internal constructor() {
    private var action: Output<Either<String, Action>>? = null

    private var addressList: Output<List<String>>? = null

    /**
     * @param value Specify action.
     */
    @JvmName("oolvhhhtenrykyvc")
    public suspend fun action(`value`: Output<Either<String, Action>>) {
        this.action = value
    }

    /**
     * @param value List of Addresses to be allowed or denied.
     */
    @JvmName("wjuepxftotejphdt")
    public suspend fun addressList(`value`: Output<List<String>>) {
        this.addressList = value
    }

    @JvmName("wewoftbvskarscku")
    public suspend fun addressList(vararg values: Output<String>) {
        this.addressList = Output.all(values.asList())
    }

    /**
     * @param values List of Addresses to be allowed or denied.
     */
    @JvmName("ckmmltsyyqpyjfke")
    public suspend fun addressList(values: List<Output<String>>) {
        this.addressList = Output.all(values)
    }

    /**
     * @param value Specify action.
     */
    @JvmName("ykmrlednbgodnscd")
    public suspend fun action(`value`: Either<String, Action>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Specify action.
     */
    @JvmName("bsokobngedjsjyvu")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Specify action.
     */
    @JvmName("grlyymscajohrwwa")
    public fun action(`value`: Action) {
        val toBeMapped = Either.ofRight<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value List of Addresses to be allowed or denied.
     */
    @JvmName("vyvamjftcytlilre")
    public suspend fun addressList(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressList = mapped
    }

    /**
     * @param values List of Addresses to be allowed or denied.
     */
    @JvmName("dvjhekgtqyqyfahd")
    public suspend fun addressList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressList = mapped
    }

    internal fun build(): RulePropertiesArgs = RulePropertiesArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        addressList = addressList ?: throw PulumiNullFieldException("addressList"),
    )
}
