@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.VlanGroupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Vlan group properties.
 * @property name Vlan group name.
 * @property vlans List of vlans.
 */
public data class VlanGroupPropertiesArgs(
    public val name: Output<String>? = null,
    public val vlans: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.VlanGroupPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.VlanGroupPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.VlanGroupPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .vlans(vlans?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VlanGroupPropertiesArgs].
 */
@PulumiTagMarker
public class VlanGroupPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var vlans: Output<List<String>>? = null

    /**
     * @param value Vlan group name.
     */
    @JvmName("pivnwqkeimflbdgr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of vlans.
     */
    @JvmName("ydyjtvxstgoacomv")
    public suspend fun vlans(`value`: Output<List<String>>) {
        this.vlans = value
    }

    @JvmName("dqiqtfvtbxivvkjd")
    public suspend fun vlans(vararg values: Output<String>) {
        this.vlans = Output.all(values.asList())
    }

    /**
     * @param values List of vlans.
     */
    @JvmName("utmmtmvrimposhei")
    public suspend fun vlans(values: List<Output<String>>) {
        this.vlans = Output.all(values)
    }

    /**
     * @param value Vlan group name.
     */
    @JvmName("phkwpmmkrnyhqfrs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of vlans.
     */
    @JvmName("hqdtkbhankqsdube")
    public suspend fun vlans(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlans = mapped
    }

    /**
     * @param values List of vlans.
     */
    @JvmName("gsfmyaduedqelghn")
    public suspend fun vlans(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vlans = mapped
    }

    internal fun build(): VlanGroupPropertiesArgs = VlanGroupPropertiesArgs(
        name = name,
        vlans = vlans,
    )
}
