@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.VpnConfigurationPropertiesArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.PeeringOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration for infrastructure vpn.
 * @property optionAProperties option A properties
 * @property optionBProperties option B properties
 * @property peeringOption Peering option list.
 */
public data class VpnConfigurationPropertiesArgs(
    public val optionAProperties: Output<OptionAPropertiesArgs>? = null,
    public val optionBProperties: Output<FabricOptionBPropertiesArgs>? = null,
    public val peeringOption: Output<Either<String, PeeringOption>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.VpnConfigurationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.VpnConfigurationPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.VpnConfigurationPropertiesArgs.builder()
            .optionAProperties(optionAProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .optionBProperties(optionBProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .peeringOption(
                peeringOption.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VpnConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class VpnConfigurationPropertiesArgsBuilder internal constructor() {
    private var optionAProperties: Output<OptionAPropertiesArgs>? = null

    private var optionBProperties: Output<FabricOptionBPropertiesArgs>? = null

    private var peeringOption: Output<Either<String, PeeringOption>>? = null

    /**
     * @param value option A properties
     */
    @JvmName("ysqgkhugailiajpd")
    public suspend fun optionAProperties(`value`: Output<OptionAPropertiesArgs>) {
        this.optionAProperties = value
    }

    /**
     * @param value option B properties
     */
    @JvmName("osuqckvxshemyaht")
    public suspend fun optionBProperties(`value`: Output<FabricOptionBPropertiesArgs>) {
        this.optionBProperties = value
    }

    /**
     * @param value Peering option list.
     */
    @JvmName("hrjqncdxqwrbvwgw")
    public suspend fun peeringOption(`value`: Output<Either<String, PeeringOption>>) {
        this.peeringOption = value
    }

    /**
     * @param value option A properties
     */
    @JvmName("unnuqmbaxftksqql")
    public suspend fun optionAProperties(`value`: OptionAPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionAProperties = mapped
    }

    /**
     * @param argument option A properties
     */
    @JvmName("vhntemmsjkyoagki")
    public suspend fun optionAProperties(argument: suspend OptionAPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = OptionAPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.optionAProperties = mapped
    }

    /**
     * @param value option B properties
     */
    @JvmName("kjqfvuejqnmxqfol")
    public suspend fun optionBProperties(`value`: FabricOptionBPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionBProperties = mapped
    }

    /**
     * @param argument option B properties
     */
    @JvmName("obwcrgujmlsaaunk")
    public suspend
    fun optionBProperties(argument: suspend FabricOptionBPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FabricOptionBPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.optionBProperties = mapped
    }

    /**
     * @param value Peering option list.
     */
    @JvmName("axdcfmsatvlopqhf")
    public suspend fun peeringOption(`value`: Either<String, PeeringOption>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringOption = mapped
    }

    /**
     * @param value Peering option list.
     */
    @JvmName("kraifrhnbpjxuujm")
    public fun peeringOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PeeringOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringOption = mapped
    }

    /**
     * @param value Peering option list.
     */
    @JvmName("ibdxakaonluhorac")
    public fun peeringOption(`value`: PeeringOption) {
        val toBeMapped = Either.ofRight<String, PeeringOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringOption = mapped
    }

    internal fun build(): VpnConfigurationPropertiesArgs = VpnConfigurationPropertiesArgs(
        optionAProperties = optionAProperties,
        optionBProperties = optionBProperties,
        peeringOption = peeringOption ?: throw PulumiNullFieldException("peeringOption"),
    )
}
