@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * BFD configuration properties
 * @property administrativeState Administrative state of the BfdConfiguration. Example: Enabled | Disabled.
 * @property interval interval in milliseconds. Example: 300.
 * @property multiplier Multiplier for the Bfd Configuration. Example: 3.
 */
public data class BfdConfigurationResponse(
    public val administrativeState: String,
    public val interval: Int,
    public val multiplier: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.BfdConfigurationResponse):
            BfdConfigurationResponse = BfdConfigurationResponse(
            administrativeState = javaType.administrativeState(),
            interval = javaType.interval(),
            multiplier = javaType.multiplier(),
        )
    }
}
