@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The IpCommunity resource definition.
 * @property action Action to be taken on the configuration. Example: Permit | Deny.
 * @property annotation Switch configuration description.
 * @property communityMembers List the communityMembers of IP Community .
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Gets the provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property wellKnownCommunities Supported well known Community List.
 */
public data class GetIpCommunityResult(
    public val action: String,
    public val `annotation`: String? = null,
    public val communityMembers: List<String>,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val wellKnownCommunities: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetIpCommunityResult):
            GetIpCommunityResult = GetIpCommunityResult(
            action = javaType.action(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            communityMembers = javaType.communityMembers().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            wellKnownCommunities = javaType.wellKnownCommunities().map({ args0 -> args0 }),
        )
    }
}
