@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The NetworkDevice resource definition.
 * @property annotation Switch configuration description.
 * @property hostName The host Name of the device.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkDeviceRole networkDeviceRole is the device role: Example: CE | ToR.
 * @property networkDeviceSku Network Device SKU name.
 * @property networkRackId Reference to network rack resource id.
 * @property provisioningState Gets the provisioning state of the resource.
 * @property serialNumber serialNumber of the format Make;Model;HardwareRevisionId;SerialNumber. Example: Arista;DCS-7280DR3-24;12.05;JPE21116969
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Current version of the device as defined in SKU.
 */
public data class GetNetworkDeviceResult(
    public val `annotation`: String? = null,
    public val hostName: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val networkDeviceRole: String,
    public val networkDeviceSku: String,
    public val networkRackId: String,
    public val provisioningState: String,
    public val serialNumber: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkDeviceResult):
            GetNetworkDeviceResult = GetNetworkDeviceResult(
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            networkDeviceRole = javaType.networkDeviceRole(),
            networkDeviceSku = javaType.networkDeviceSku(),
            networkRackId = javaType.networkRackId(),
            provisioningState = javaType.provisioningState(),
            serialNumber = javaType.serialNumber(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
