@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The response of the action validate configuration.
 * @property configurationState Gets the configuration state.
 * @property error The error object.
 * @property url URL for the details of the response.
 */
public data class GetNetworkFabricTopologyResult(
    public val configurationState: String,
    public val error: ErrorDetailResponse? = null,
    public val url: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkFabricTopologyResult):
            GetNetworkFabricTopologyResult = GetNetworkFabricTopologyResult(
            configurationState = javaType.configurationState(),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
