@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The NetworkPacketBroker resource definition.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property neighborGroupIds List of neighbor group IDs configured on NPB.
 * @property networkDeviceIds List of ARM resource IDs of Network Devices [NPB].
 * @property networkFabricId ARM resource ID of the Network Fabric.
 * @property networkTapIds List of network Tap IDs configured on NPB.
 * @property provisioningState Provisioning state of the resource.
 * @property sourceInterfaceIds List of network interfaces across NPB devices that are used to mirror source traffic.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNetworkPacketBrokerResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val neighborGroupIds: List<String>,
    public val networkDeviceIds: List<String>,
    public val networkFabricId: String,
    public val networkTapIds: List<String>,
    public val provisioningState: String,
    public val sourceInterfaceIds: List<String>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkPacketBrokerResult):
            GetNetworkPacketBrokerResult = GetNetworkPacketBrokerResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            neighborGroupIds = javaType.neighborGroupIds().map({ args0 -> args0 }),
            networkDeviceIds = javaType.networkDeviceIds().map({ args0 -> args0 }),
            networkFabricId = javaType.networkFabricId(),
            networkTapIds = javaType.networkTapIds().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            sourceInterfaceIds = javaType.sourceInterfaceIds().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
