@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The NetworkToNetworkInterconnect resource definition.
 * @property administrativeState Gets the administrativeState of the resource. Example -Enabled/Disabled
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isManagementType Configuration to use NNI for Infrastructure Management. Example: True/False.
 * @property layer2Configuration Common properties for Layer2Configuration.
 * @property layer3Configuration Common properties for Layer3Configuration.
 * @property name The name of the resource
 * @property nniType Type of NNI used. Example: CE | NPB
 * @property provisioningState Gets the provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property useOptionB Based on this parameter the layer2/layer3 is made as mandatory. Example: True/False
 */
public data class GetNetworkToNetworkInterconnectResult(
    public val administrativeState: String,
    public val id: String,
    public val isManagementType: String,
    public val layer2Configuration: Layer2ConfigurationResponse? = null,
    public val layer3Configuration: Layer3ConfigurationResponse? = null,
    public val name: String,
    public val nniType: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val useOptionB: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkToNetworkInterconnectResult):
            GetNetworkToNetworkInterconnectResult = GetNetworkToNetworkInterconnectResult(
            administrativeState = javaType.administrativeState(),
            id = javaType.id(),
            isManagementType = javaType.isManagementType(),
            layer2Configuration = javaType.layer2Configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.Layer2ConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            layer3Configuration = javaType.layer3Configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.Layer3ConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            nniType = javaType.nniType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            useOptionB = javaType.useOptionB(),
        )
    }
}
